/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server.upgrade;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationStateManager;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;

public final class SCMUpgradeFinalizationContext {
    private final PipelineManager pipelineManager;
    private final NodeManager nodeManager;
    private final FinalizationStateManager finalizationStateManager;
    private final SCMStorageConfig storage;
    private final HDDSLayoutVersionManager versionManager;
    private final OzoneConfiguration conf;
    private final SCMContext scmContext;

    private SCMUpgradeFinalizationContext(Builder builder) {
        this.pipelineManager = builder.pipelineManager;
        this.nodeManager = builder.nodeManager;
        this.finalizationStateManager = builder.finalizationStateManager;
        this.storage = builder.storage;
        this.versionManager = builder.versionManager;
        this.conf = builder.conf;
        this.scmContext = builder.scmContext;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public PipelineManager getPipelineManager() {
        return this.pipelineManager;
    }

    public FinalizationStateManager getFinalizationStateManager() {
        return this.finalizationStateManager;
    }

    public OzoneConfiguration getConfiguration() {
        return this.conf;
    }

    public HDDSLayoutVersionManager getLayoutVersionManager() {
        return this.versionManager;
    }

    public SCMContext getSCMContext() {
        return this.scmContext;
    }

    public SCMStorageConfig getStorage() {
        return this.storage;
    }

    public static final class Builder {
        private PipelineManager pipelineManager;
        private NodeManager nodeManager;
        private FinalizationStateManager finalizationStateManager;
        private SCMStorageConfig storage;
        private HDDSLayoutVersionManager versionManager;
        private OzoneConfiguration conf;
        private SCMContext scmContext;

        public Builder setSCMContext(SCMContext context) {
            this.scmContext = context;
            return this;
        }

        public Builder setPipelineManager(PipelineManager pipelineManager) {
            this.pipelineManager = pipelineManager;
            return this;
        }

        public Builder setNodeManager(NodeManager nodeManager) {
            this.nodeManager = nodeManager;
            return this;
        }

        public Builder setFinalizationStateManager(FinalizationStateManager finalizationStateManager) {
            this.finalizationStateManager = finalizationStateManager;
            return this;
        }

        public Builder setStorage(SCMStorageConfig storage) {
            this.storage = storage;
            return this;
        }

        public Builder setLayoutVersionManager(HDDSLayoutVersionManager versionManager) {
            this.versionManager = versionManager;
            return this;
        }

        public Builder setConfiguration(OzoneConfiguration conf) {
            this.conf = conf;
            return this;
        }

        public SCMUpgradeFinalizationContext build() {
            Preconditions.checkNotNull((Object)this.scmContext);
            Preconditions.checkNotNull((Object)this.pipelineManager);
            Preconditions.checkNotNull((Object)this.nodeManager);
            Preconditions.checkNotNull((Object)((Object)this.storage));
            Preconditions.checkNotNull((Object)this.versionManager);
            Preconditions.checkNotNull((Object)this.conf);
            Preconditions.checkNotNull((Object)this.finalizationStateManager);
            return new SCMUpgradeFinalizationContext(this);
        }
    }
}

