/*
 * Decompiled with CFR 0.152.
 */
package com.force.i18n;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum LocaleUtils {
    INSTANCE;

    private static final ConcurrentMap<Locale, Locale> uniqueLocaleMap;

    public static LocaleUtils get() {
        return INSTANCE;
    }

    public Locale getLocaleByIsoCode(String isoCode) {
        if (isoCode == null) {
            return null;
        }
        if (isoCode.length() == 2) {
            return LocaleUtils.uniqueifyLocale(new Locale(isoCode));
        }
        if (isoCode.length() == 5) {
            String countryIsoCode = isoCode.substring(3, 5);
            String langIsoCode = isoCode.substring(0, 2);
            return LocaleUtils.uniqueifyLocale(new Locale(langIsoCode, countryIsoCode));
        }
        ArrayList split = Lists.newArrayList((Iterable)Splitter.on((char)'_').split((CharSequence)isoCode));
        String language = (String)split.get(0);
        String country = split.size() > 1 ? (String)split.get(1) : "";
        String variant = split.size() > 2 ? (String)split.get(2) : "";
        return LocaleUtils.uniqueifyLocale(new Locale(language, country, variant));
    }

    public Locale getLocaleFromDbString(String value) {
        if (value == null || "null".equals(value)) {
            return null;
        }
        return this.getLocaleByIsoCode(value);
    }

    public Locale getLocaleFromHttpInput(String str) {
        if ("*".equals(str)) {
            return null;
        }
        int semiIndex = str.indexOf(59);
        String locale = str;
        if (semiIndex > 0) {
            locale = str.substring(0, semiIndex);
        }
        if (locale.length() == 2) {
            return new Locale(locale.toLowerCase());
        }
        if (locale.length() == 5) {
            if (locale.charAt(2) != '-') {
                return null;
            }
            return new Locale(locale.substring(0, 2).toLowerCase(), locale.substring(3, 5).toUpperCase());
        }
        return null;
    }

    static Locale uniqueifyLocale(Locale value) {
        if (value == null) {
            return null;
        }
        Locale oldValue = (Locale)uniqueLocaleMap.get(value);
        if (oldValue != null) {
            return oldValue;
        }
        uniqueLocaleMap.put(value, value);
        return value;
    }

    static {
        uniqueLocaleMap = new ConcurrentHashMap<Locale, Locale>(64, 0.75f, 2);
    }
}

