/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.filter.SystemCatalogViewIndexIdFilter;
import org.apache.phoenix.util.ScanUtil;

public class SystemCatalogRegionObserver
extends BaseRegionObserver {
    public void start(CoprocessorEnvironment e) throws IOException {
        super.start(e);
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        super.stop(e);
    }

    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        int clientVersion = ScanUtil.getClientVersion(scan);
        if (clientVersion != ScanUtil.UNKNOWN_CLIENT_VERSION) {
            ScanUtil.andFilterAtBeginning(scan, (Filter)new SystemCatalogViewIndexIdFilter(clientVersion));
        }
        return s;
    }
}

