/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.WALAnnotationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UngroupedAggregateRegionScanner
extends BaseRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(UngroupedAggregateRegionScanner.class);
    private long pageSizeMs;
    private int maxBatchSize = 0;
    private final Scan scan;
    private final RegionScanner innerScanner;
    private final Region region;
    private final UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver;
    private final RegionCoprocessorEnvironment env;
    private final boolean useQualifierAsIndex;
    private boolean needToWrite = false;
    private final Pair<Integer, Integer> minMaxQualifiers;
    private byte[][] values = null;
    private final PTable.QualifierEncodingScheme encodingScheme;
    private PTable writeToTable = null;
    private PTable projectedTable = null;
    private final boolean isDescRowKeyOrderUpgrade;
    private final int offset;
    private final boolean buildLocalIndex;
    private final List<IndexMaintainer> indexMaintainers;
    private boolean isPKChanging = false;
    private final long ts;
    private PhoenixTransactionProvider txnProvider = null;
    private final UngroupedAggregateRegionObserver.MutationList indexMutations;
    private boolean isDelete = false;
    private final byte[] replayMutations;
    private boolean isUpsert = false;
    private List<Expression> selectExpressions = null;
    private byte[] deleteCQ = null;
    private byte[] deleteCF = null;
    private byte[] emptyCF = null;
    private final byte[] indexUUID;
    private final byte[] txState;
    private final byte[] clientVersionBytes;
    private final long blockingMemStoreSize;
    private long maxBatchSizeBytes = 0L;
    private HTable targetHTable = null;
    private boolean incrScanRefCount = false;
    private byte[] indexMaintainersPtr;
    private boolean useIndexProto;

    public UngroupedAggregateRegionScanner(ObserverContext<RegionCoprocessorEnvironment> c, RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver) throws IOException, SQLException {
        super(innerScanner);
        byte[] upsertSelectTable;
        this.env = env;
        this.region = region;
        this.scan = scan;
        this.ungroupedAggregateRegionObserver = ungroupedAggregateRegionObserver;
        this.innerScanner = innerScanner;
        Configuration conf = env.getConfiguration();
        this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner(scan);
        this.ts = scan.getTimeRange().getMax();
        boolean localIndexScan = ScanUtil.isLocalIndex(scan);
        this.encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme(scan);
        int offsetToBe = 0;
        if (localIndexScan) {
            offsetToBe = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
            ScanUtil.setRowKeyOffset(scan, offsetToBe);
        }
        this.offset = offsetToBe;
        byte[] descRowKeyTableBytes = scan.getAttribute("_UPGRADE_DESC_ROW_KEY");
        boolean bl = this.isDescRowKeyOrderUpgrade = descRowKeyTableBytes != null;
        if (this.isDescRowKeyOrderUpgrade) {
            LOGGER.debug("Upgrading row key for " + region.getRegionInfo().getTable().getNameAsString());
            this.projectedTable = UngroupedAggregateRegionObserver.deserializeTable(descRowKeyTableBytes);
            try {
                this.writeToTable = PTableImpl.builderWithColumns(this.projectedTable, PTableImpl.getColumnsToClone(this.projectedTable)).setRowKeyOrderOptimizable(true).build();
            }
            catch (SQLException e) {
                ServerUtil.throwIOException("Upgrade failed", e);
            }
            this.values = new byte[this.projectedTable.getPKColumns().size()][];
        }
        boolean useProto = false;
        byte[] localIndexBytes = scan.getAttribute("_LocalIndexBuild");
        boolean bl2 = useProto = localIndexBytes != null;
        if (localIndexBytes == null) {
            localIndexBytes = scan.getAttribute("_LocalIndexBuild");
        }
        this.indexMaintainers = localIndexBytes == null ? null : IndexMaintainer.deserialize(localIndexBytes, useProto);
        this.indexMutations = localIndexBytes == null ? new UngroupedAggregateRegionObserver.MutationList() : new UngroupedAggregateRegionObserver.MutationList(1024);
        this.replayMutations = scan.getAttribute("_IGNORE_NEWER_MUTATIONS");
        this.indexUUID = scan.getAttribute("IdxUUID");
        this.txState = scan.getAttribute("_TxState");
        this.clientVersionBytes = scan.getAttribute("_ClientVersion");
        if (this.txState != null) {
            int clientVersion = this.clientVersionBytes == null ? ScanUtil.UNKNOWN_CLIENT_VERSION : Bytes.toInt((byte[])this.clientVersionBytes);
            this.txnProvider = TransactionFactory.getTransactionProvider(this.txState, clientVersion);
        }
        if ((upsertSelectTable = scan.getAttribute("_UpsertSelectTable")) != null) {
            this.isUpsert = true;
            this.projectedTable = UngroupedAggregateRegionObserver.deserializeTable(upsertSelectTable);
            this.targetHTable = new HTable(ungroupedAggregateRegionObserver.getUpsertSelectConfig(), this.projectedTable.getPhysicalName().getBytes());
            this.selectExpressions = UngroupedAggregateRegionObserver.deserializeExpressions(scan.getAttribute("_UpsertSelectExprs"));
            this.values = new byte[this.projectedTable.getPKColumns().size()][];
            this.isPKChanging = ExpressionUtil.isPkPositionChanging(new TableRef(this.projectedTable), this.selectExpressions);
        } else {
            byte[] isDeleteAgg = scan.getAttribute("_DeleteAgg");
            boolean bl3 = this.isDelete = isDeleteAgg != null && Bytes.compareTo((byte[])PDataType.TRUE_BYTES, (byte[])isDeleteAgg) == 0;
            if (!this.isDelete) {
                this.deleteCF = scan.getAttribute("_DeleteCF");
                this.deleteCQ = scan.getAttribute("_DeleteCQ");
            }
            this.emptyCF = scan.getAttribute("_EmptyCF");
        }
        ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin(scan);
        this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan));
        this.blockingMemStoreSize = UngroupedAggregateRegionObserver.getBlockingMemstoreSize(region, conf);
        boolean bl4 = this.buildLocalIndex = this.indexMaintainers != null && dataColumns == null && !localIndexScan;
        if (this.buildLocalIndex) {
            UngroupedAggregateRegionObserver.checkForLocalIndexColumnFamilies(region, this.indexMaintainers);
        }
        if (this.isDescRowKeyOrderUpgrade || this.isDelete || this.isUpsert || this.deleteCQ != null && this.deleteCF != null || this.emptyCF != null || this.buildLocalIndex) {
            this.needToWrite = true;
            if (this.isUpsert && (this.targetHTable == null || !this.targetHTable.getName().equals((Object)region.getTableDesc().getTableName()))) {
                this.needToWrite = false;
            }
            this.maxBatchSize = conf.getInt("phoenix.mutate.batchSize", 100);
            this.maxBatchSizeBytes = conf.getLong("phoenix.mutate.batchSizeBytes", 0x200000L);
        }
        this.minMaxQualifiers = EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LogUtil.addCustomAnnotations("Starting ungrouped coprocessor scan " + scan + " " + region.getRegionInfo(), ScanUtil.getCustomAnnotations(scan)));
        }
        this.useIndexProto = true;
        this.indexMaintainersPtr = scan.getAttribute("IdxProtoMD");
        if (this.indexMaintainersPtr == null) {
            this.indexMaintainersPtr = scan.getAttribute("IdxMD");
            this.useIndexProto = false;
        }
        if (this.needToWrite) {
            ungroupedAggregateRegionObserver.incrementScansReferenceCount();
            this.incrScanRefCount = true;
        }
    }

    @Override
    public HRegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    @Override
    public boolean isFilterDone() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.needToWrite && this.incrScanRefCount) {
            this.ungroupedAggregateRegionObserver.decrementScansReferenceCount();
        }
        try {
            if (this.targetHTable != null) {
                try {
                    this.targetHTable.close();
                }
                catch (IOException e) {
                    LOGGER.error("Closing table: " + this.targetHTable + " failed: ", (Throwable)e);
                }
            }
        }
        finally {
            this.innerScanner.close();
        }
    }

    boolean descRowKeyOrderUpgrade(List<Cell> results, ImmutableBytesWritable ptr, UngroupedAggregateRegionObserver.MutationList mutations) throws IOException {
        Boolean hasValue;
        Arrays.fill((Object[])this.values, null);
        Cell firstKV = results.get(0);
        RowKeySchema schema = this.projectedTable.getRowKeySchema();
        int maxOffset = schema.iterator(firstKV.getRowArray(), firstKV.getRowOffset() + this.offset, firstKV.getRowLength(), ptr);
        for (int i = 0; i < schema.getFieldCount() && (hasValue = schema.next(ptr, i, maxOffset)) != null; ++i) {
            int len;
            ValueSchema.Field field = schema.getField(i);
            if (field.getSortOrder() == SortOrder.DESC) {
                if (field.getDataType().isArrayType()) {
                    field.getDataType().coerceBytes(ptr, null, field.getDataType(), field.getMaxLength(), field.getScale(), field.getSortOrder(), field.getMaxLength(), field.getScale(), field.getSortOrder(), true);
                } else if (field.getDataType() == PChar.INSTANCE || field.getDataType() == PBinary.INSTANCE) {
                    for (len = ptr.getLength(); len > 0 && ptr.get()[ptr.getOffset() + len - 1] == 32; --len) {
                    }
                    ptr.set(ptr.get(), ptr.getOffset(), len);
                } else if (field.getDataType() == PFloat.INSTANCE || field.getDataType() == PDouble.INSTANCE) {
                    byte[] invertedBytes = SortOrder.invert(ptr.get(), ptr.getOffset(), ptr.getLength());
                    ptr.set(invertedBytes);
                }
            } else if (field.getDataType() == PBinary.INSTANCE) {
                for (len = ptr.getLength(); len > 0 && ptr.get()[ptr.getOffset() + len - 1] == 32; --len) {
                }
                ptr.set(ptr.get(), ptr.getOffset(), len);
            }
            this.values[i] = ptr.copyBytes();
        }
        this.writeToTable.newKey(ptr, this.values);
        if (Bytes.compareTo((byte[])firstKV.getRowArray(), (int)(firstKV.getRowOffset() + this.offset), (int)firstKV.getRowLength(), (byte[])ptr.get(), (int)(ptr.getOffset() + this.offset), (int)ptr.getLength()) == 0) {
            return false;
        }
        byte[] newRow = ByteUtil.copyKeyBytesIfNecessary(ptr);
        if (this.offset > 0) {
            byte[] newRowWithOffset = new byte[this.offset + newRow.length];
            System.arraycopy(firstKV.getRowArray(), firstKV.getRowOffset(), newRowWithOffset, 0, this.offset);
            System.arraycopy(newRow, 0, newRowWithOffset, this.offset, newRow.length);
            newRow = newRowWithOffset;
        }
        byte[] oldRow = Bytes.copy((byte[])firstKV.getRowArray(), (int)firstKV.getRowOffset(), (int)firstKV.getRowLength());
        for (Cell cell : results) {
            Cell newCell = CellUtil.createCell((byte[])newRow, (byte[])CellUtil.cloneFamily((Cell)cell), (byte[])CellUtil.cloneQualifier((Cell)cell), (long)cell.getTimestamp(), (byte)cell.getTypeByte(), (byte[])CellUtil.cloneValue((Cell)cell));
            switch (KeyValue.Type.codeToType((byte)cell.getTypeByte())) {
                case Put: {
                    Delete del = new Delete(oldRow);
                    del.addDeleteMarker(CellUtil.createCell((byte[])CellUtil.cloneRow((Cell)cell), (byte[])CellUtil.cloneFamily((Cell)cell), (byte[])CellUtil.cloneQualifier((Cell)cell), (long)cell.getTimestamp(), (byte)KeyValue.Type.Delete.getCode(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY));
                    mutations.add((Mutation)del);
                    Put put = new Put(newRow);
                    put.add(newCell);
                    mutations.add((Mutation)put);
                    break;
                }
                case Delete: 
                case DeleteColumn: 
                case DeleteFamily: 
                case DeleteFamilyVersion: {
                    Delete delete = new Delete(newRow);
                    delete.addDeleteMarker(newCell);
                    mutations.add((Mutation)delete);
                }
            }
        }
        return true;
    }

    void buildLocalIndex(Tuple result, List<Cell> results, ImmutableBytesWritable ptr) throws IOException {
        for (IndexMaintainer maintainer : this.indexMaintainers) {
            if (results.isEmpty()) continue;
            result.getKey(ptr);
            ValueGetter valueGetter = maintainer.createGetterFromKeyValues(ImmutableBytesPtr.copyBytesIfNecessary(ptr), results);
            Put put = maintainer.buildUpdateMutation(GenericKeyValueBuilder.INSTANCE, valueGetter, ptr, results.get(0).getTimestamp(), this.env.getRegion().getRegionInfo().getStartKey(), this.env.getRegion().getRegionInfo().getEndKey());
            if (this.txnProvider != null) {
                put = this.txnProvider.markPutAsCommitted(put, this.ts, this.ts);
            }
            this.indexMutations.add((Mutation)put);
        }
        result.setKeyValues(results);
    }

    void deleteRow(List<Cell> results, UngroupedAggregateRegionObserver.MutationList mutations) {
        byte[] sourceOperationBytes;
        Cell firstKV = results.get(0);
        Delete delete = new Delete(firstKV.getRowArray(), firstKV.getRowOffset(), (int)firstKV.getRowLength(), this.ts);
        if (this.replayMutations != null) {
            delete.setAttribute("_IGNORE_NEWER_MUTATIONS", this.replayMutations);
        }
        if ((sourceOperationBytes = this.scan.getAttribute("phoenix.source.operation")) != null) {
            delete.setAttribute("phoenix.source.operation", sourceOperationBytes);
        }
        mutations.add((Mutation)delete);
        delete.setAttribute("tephra.tx.rollback", new byte[0]);
    }

    void deleteCForQ(Tuple result, List<Cell> results, UngroupedAggregateRegionObserver.MutationList mutations) {
        if (this.emptyCF == null || result.getValue(this.deleteCF, this.deleteCQ) != null) {
            Delete delete = new Delete(results.get(0).getRowArray(), results.get(0).getRowOffset(), (int)results.get(0).getRowLength());
            delete.deleteColumns(this.deleteCF, this.deleteCQ, this.ts);
            delete.setAttribute("tephra.tx.rollback", new byte[0]);
            mutations.add((Mutation)delete);
        }
    }

    void upsert(Tuple result, ImmutableBytesWritable ptr, UngroupedAggregateRegionObserver.MutationList mutations) {
        int i;
        Arrays.fill((Object[])this.values, null);
        int bucketNumOffset = 0;
        if (this.projectedTable.getBucketNum() != null) {
            this.values[0] = new byte[]{0};
            bucketNumOffset = 1;
        }
        List<PColumn> projectedColumns = this.projectedTable.getColumns();
        for (i = bucketNumOffset; i < this.projectedTable.getPKColumns().size(); ++i) {
            Expression expression = this.selectExpressions.get(i - bucketNumOffset);
            if (expression.evaluate(result, ptr)) {
                this.values[i] = ptr.copyBytes();
                if (expression.getSortOrder() == projectedColumns.get(i).getSortOrder()) continue;
                SortOrder.invert(this.values[i], 0, this.values[i], 0, this.values[i].length);
                continue;
            }
            this.values[i] = ByteUtil.EMPTY_BYTE_ARRAY;
        }
        this.projectedTable.newKey(ptr, this.values);
        PRow row = this.projectedTable.newRow(GenericKeyValueBuilder.INSTANCE, this.ts, ptr, false, (byte[][])new byte[0][]);
        while (i < projectedColumns.size()) {
            Expression expression = this.selectExpressions.get(i - bucketNumOffset);
            if (expression.evaluate(result, ptr)) {
                PColumn column = projectedColumns.get(i);
                if (!column.getDataType().isSizeCompatible(ptr, null, expression.getDataType(), expression.getSortOrder(), expression.getMaxLength(), expression.getScale(), column.getMaxLength(), column.getScale())) {
                    throw new DataExceedsCapacityException(column.getDataType(), column.getMaxLength(), column.getScale(), column.getName().getString(), ptr);
                }
                column.getDataType().coerceBytes(ptr, null, expression.getDataType(), expression.getMaxLength(), expression.getScale(), expression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder(), this.projectedTable.rowKeyOrderOptimizable());
                byte[] bytes = ByteUtil.copyKeyBytesIfNecessary(ptr);
                row.setValue(column, bytes);
            }
            ++i;
        }
        for (Mutation mutation : row.toRowMutations()) {
            if (this.replayMutations != null) {
                mutation.setAttribute("_IGNORE_NEWER_MUTATIONS", this.replayMutations);
            } else if (this.txnProvider != null && this.projectedTable.getType() == PTableType.INDEX) {
                mutation = this.txnProvider.markPutAsCommitted((Put)mutation, this.ts, this.ts);
            }
            mutations.add(mutation);
        }
        for (i = 0; i < this.selectExpressions.size(); ++i) {
            this.selectExpressions.get(i).reset();
        }
    }

    void insertEmptyKeyValue(List<Cell> results, UngroupedAggregateRegionObserver.MutationList mutations) {
        HashSet timeStamps = Sets.newHashSetWithExpectedSize((int)results.size());
        for (Cell kv : results) {
            long kvts = kv.getTimestamp();
            if (timeStamps.contains(kvts)) continue;
            Put put = new Put(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength());
            put.addColumn(this.emptyCF, QueryConstants.EMPTY_COLUMN_BYTES, kvts, ByteUtil.EMPTY_BYTE_ARRAY);
            mutations.add((Mutation)put);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean next(List<Cell> resultsToReturn) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 26[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void annotateAndCommit(UngroupedAggregateRegionObserver.MutationList mutations) throws IOException {
        if (this.isDelete || this.isUpsert) {
            this.annotateDataMutations(mutations, this.scan);
        }
        this.ungroupedAggregateRegionObserver.commit(this.region, mutations, this.indexUUID, this.blockingMemStoreSize, this.indexMaintainersPtr, this.txState, this.targetHTable, this.useIndexProto, this.isPKChanging, this.clientVersionBytes);
        mutations.clear();
    }

    @Override
    public long getMaxResultSize() {
        return this.scan.getMaxResultSize();
    }

    private void annotateDataMutations(UngroupedAggregateRegionObserver.MutationList mutationsList, Scan scan) {
        byte[] tenantId = scan.getAttribute(MutationState.MutationMetadataType.TENANT_ID.toString());
        byte[] schemaName = scan.getAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString());
        byte[] logicalTableName = scan.getAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString());
        byte[] tableType = scan.getAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString());
        byte[] ddlTimestamp = scan.getAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString());
        for (Mutation m : mutationsList) {
            WALAnnotationUtil.annotateMutation(m, tenantId, schemaName, logicalTableName, tableType, ddlTimestamp);
        }
    }
}

