/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.ColumnValueEncoder;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;

public class SingleCellConstructorExpression
extends BaseCompoundExpression {
    private PTable.ImmutableStorageScheme immutableStorageScheme;

    public SingleCellConstructorExpression(PTable.ImmutableStorageScheme immutableStorageScheme, List<Expression> children) {
        super(children);
        this.immutableStorageScheme = immutableStorageScheme;
    }

    @Override
    public PDataType getDataType() {
        return PVarbinary.INSTANCE;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        ColumnValueEncoder encoderDecoder = this.immutableStorageScheme.getEncoder(this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = (Expression)this.children.get(i);
            if (!child.evaluate(tuple, ptr)) {
                encoderDecoder.appendAbsentValue();
                continue;
            }
            encoderDecoder.appendValue(ptr.get(), ptr.getOffset(), ptr.getLength());
        }
        byte[] bytes = encoderDecoder.encode();
        ptr.set(bytes, 0, bytes.length);
        return true;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.immutableStorageScheme = (PTable.ImmutableStorageScheme)WritableUtils.readEnum((DataInput)input, PTable.ImmutableStorageScheme.class);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeEnum((DataOutput)output, (Enum)this.immutableStorageScheme);
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        if (this.children.size() == 0) {
            return buf.append("]").toString();
        }
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + ",");
        }
        buf.append(this.children.get(this.children.size() - 1) + "]");
        return buf.toString();
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public SingleCellConstructorExpression clone(List<Expression> children) {
        return new SingleCellConstructorExpression(this.immutableStorageScheme, children);
    }
}

