/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.JavaMathTwoArgumentFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;

@FunctionParseNode.BuiltInFunction(name="LOG", args={@FunctionParseNode.Argument(allowedTypes={PDouble.class, PDecimal.class}), @FunctionParseNode.Argument(allowedTypes={PDouble.class, PDecimal.class}, defaultValue="1e1")})
public class LogFunction
extends JavaMathTwoArgumentFunction {
    public static final String NAME = "LOG";

    public LogFunction() {
    }

    public LogFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected double compute(double firstArg, double secondArg) {
        return Math.log(firstArg) / Math.log(secondArg);
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES;
    }
}

