/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

@FunctionParseNode.BuiltInFunction(name="TRIM", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class TrimFunction
extends ScalarFunction {
    public static final String NAME = "TRIM";
    private Integer maxLength;

    public TrimFunction() {
    }

    public TrimFunction(List<Expression> children) throws SQLException {
        super(children);
        if (this.getStringExpression().getDataType().isFixedWidth()) {
            this.maxLength = this.getStringExpression().getMaxLength();
        }
    }

    private Expression getStringExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public SortOrder getSortOrder() {
        return ((Expression)this.children.get(0)).getSortOrder();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        SortOrder sortOrder;
        int length;
        int offset;
        if (!this.getStringExpression().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        byte[] string = ptr.get();
        int end = StringUtil.getFirstNonBlankCharIdxFromEnd(string, offset = ptr.getOffset(), length = ptr.getLength(), sortOrder = this.getSortOrder());
        if (end == offset - 1) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        int head = StringUtil.getFirstNonBlankCharIdxFromStart(string, offset, length, sortOrder);
        ptr.set(string, head, end - head + 1);
        return true;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

