/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.hbase.index.exception.SingleIndexWriteFailureException;
import org.apache.phoenix.hbase.index.parallel.QuickFailingTaskRunner;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.write.IndexCommitter;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.index.PhoenixIndexFailurePolicy;
import org.apache.phoenix.util.IndexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParallelWriterIndexCommitter
implements IndexCommitter {
    public static final String NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY = "index.writer.threads.max";
    private static final int DEFAULT_CONCURRENT_INDEX_WRITER_THREADS = 10;
    public static final String INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY = "index.writer.threads.keepalivetime";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractParallelWriterIndexCommitter.class);
    protected HTableFactory retryingFactory;
    protected HTableFactory noRetriesFactory;
    protected Stoppable stopped;
    protected QuickFailingTaskRunner pool;
    protected KeyValueBuilder kvBuilder;
    protected RegionCoprocessorEnvironment env;
    protected TaskBatch<Void> tasks;
    protected boolean disableIndexOnFailure = false;

    public AbstractParallelWriterIndexCommitter() {
    }

    public AbstractParallelWriterIndexCommitter(String hbaseVersion) {
        this.kvBuilder = KeyValueBuilder.get(hbaseVersion);
    }

    @Override
    public void setup(IndexWriter parent, RegionCoprocessorEnvironment env, String name, boolean disableIndexOnFailure) {
        this.env = env;
        this.disableIndexOnFailure = disableIndexOnFailure;
        Configuration conf = env.getConfiguration();
        this.setup(IndexWriterUtils.getDefaultDelegateHTableFactory((CoprocessorEnvironment)env), ThreadPoolManager.getExecutor(new ThreadPoolBuilder(name, conf).setMaxThread(NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY, 10).setCoreTimeout(INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY), env), parent, env);
        this.kvBuilder = KeyValueBuilder.get(env.getHBaseVersion());
    }

    public void setup(HTableFactory factory, ExecutorService pool, Stoppable stop, RegionCoprocessorEnvironment env) {
        this.retryingFactory = factory;
        this.noRetriesFactory = IndexWriterUtils.getNoRetriesHTableFactory((CoprocessorEnvironment)env);
        this.pool = new QuickFailingTaskRunner(pool);
        this.stopped = stop;
        this.env = env;
    }

    @Override
    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite, final boolean allowLocalUpdates, final int clientVersion) throws SingleIndexWriteFailureException {
        Set entries = toWrite.asMap().entrySet();
        this.tasks = new TaskBatch(entries.size());
        for (Map.Entry entry : entries) {
            final List<Mutation> mutations = this.kvBuilder.cloneIfNecessary((List)entry.getValue());
            final HTableInterfaceReference tableReference = (HTableInterfaceReference)entry.getKey();
            if (this.env != null && !allowLocalUpdates && tableReference.getTableName().equals(this.env.getRegion().getTableDesc().getTableName().getNameAsString())) continue;
            this.tasks.add(new Task<Void>(){

                @Override
                public Void call() throws Exception {
                    this.throwFailureIfDone();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Writing index update:" + mutations + " to table: " + tableReference);
                    }
                    try {
                        block20: {
                            if (allowLocalUpdates && AbstractParallelWriterIndexCommitter.this.env != null && tableReference.getTableName().equals(AbstractParallelWriterIndexCommitter.this.env.getRegion().getTableDesc().getTableName().getNameAsString())) {
                                try {
                                    this.throwFailureIfDone();
                                    IndexUtil.writeLocalUpdates(AbstractParallelWriterIndexCommitter.this.env.getRegion(), mutations, true);
                                    return null;
                                }
                                catch (IOException ignored) {
                                    if (!LOG.isDebugEnabled()) break block20;
                                    LOG.debug("indexRegion.batchMutate failed and fall back to HTable.batch(). Got error=" + ignored);
                                }
                            }
                        }
                        HTableFactory factory = AbstractParallelWriterIndexCommitter.this.disableIndexOnFailure ? (clientVersion < MetaDataProtocol.MIN_CLIENT_RETRY_INDEX_WRITES ? AbstractParallelWriterIndexCommitter.this.retryingFactory : AbstractParallelWriterIndexCommitter.this.noRetriesFactory) : AbstractParallelWriterIndexCommitter.this.retryingFactory;
                        try (HTableInterface table = factory.getTable(tableReference.get());){
                            this.throwFailureIfDone();
                            table.batch(mutations, null);
                        }
                    }
                    catch (SingleIndexWriteFailureException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw new SingleIndexWriteFailureException(tableReference.toString(), mutations, e, PhoenixIndexFailurePolicy.getDisableIndexOnFailure(AbstractParallelWriterIndexCommitter.this.env));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SingleIndexWriteFailureException(tableReference.toString(), mutations, e, PhoenixIndexFailurePolicy.getDisableIndexOnFailure(AbstractParallelWriterIndexCommitter.this.env));
                    }
                    return null;
                }

                private void throwFailureIfDone() throws SingleIndexWriteFailureException {
                    if (this.isBatchFailed() || Thread.currentThread().isInterrupted()) {
                        throw new SingleIndexWriteFailureException("Pool closed, not attempting to write to the index!", null);
                    }
                }
            });
        }
    }

    protected void propagateFailure(Throwable throwable) throws SingleIndexWriteFailureException {
        try {
            throw throwable;
        }
        catch (SingleIndexWriteFailureException e1) {
            throw e1;
        }
        catch (Throwable e1) {
            throw new SingleIndexWriteFailureException("Got an abort notification while writing to the index!", e1);
        }
    }

    public void stop(String why) {
        LOG.info("Shutting down " + this.getClass().getSimpleName() + " because " + why);
        this.pool.stop(why);
        this.retryingFactory.shutdown();
        this.noRetriesFactory.shutdown();
    }

    public boolean isStopped() {
        return this.stopped.isStopped();
    }
}

