/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.mapreduce.PhoenixOutputCommitter;
import org.apache.phoenix.mapreduce.PhoenixRecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixOutputFormat<T extends DBWritable>
extends OutputFormat<NullWritable, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixOutputFormat.class);
    private final Set<String> propsToIgnore;

    public PhoenixOutputFormat() {
        this(Collections.emptySet());
    }

    public PhoenixOutputFormat(Set<String> propsToIgnore) {
        this.propsToIgnore = propsToIgnore;
    }

    public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new PhoenixOutputCommitter();
    }

    public RecordWriter<NullWritable, T> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            return new PhoenixRecordWriter(context.getConfiguration(), this.propsToIgnore);
        }
        catch (SQLException e) {
            LOGGER.error("Error calling PhoenixRecordWriter " + e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

