/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class ArrayConstructorNode
extends CompoundParseNode {
    public ArrayConstructorNode(List<ParseNode> children) {
        super(children);
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append(' ');
        buf.append("ARRAY");
        buf.append('[');
        List<ParseNode> children = this.getChildren();
        children.get(0).toSQL(resolver, buf);
        for (int i = 1; i < children.size(); ++i) {
            buf.append(',');
            children.get(i).toSQL(resolver, buf);
        }
        buf.append(']');
    }
}

