/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.query.PhoenixStatsLoader;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixStatsCacheLoader
extends CacheLoader<GuidePostsKey, GuidePostsInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixStatsCacheLoader.class);
    private final PhoenixStatsLoader statsLoader;
    private static volatile ExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PhoenixStatsCacheLoader(PhoenixStatsLoader statsLoader, Configuration config) {
        this.statsLoader = statsLoader;
        if (executor != null) return;
        Class<PhoenixStatsCacheLoader> clazz = PhoenixStatsCacheLoader.class;
        synchronized (PhoenixStatsCacheLoader.class) {
            if (executor != null) return;
            int statsCacheThreadPoolSize = config.getInt("phoenix.stats.cache.threadPoolSize", 4);
            executor = Executors.newFixedThreadPool(statsCacheThreadPoolSize);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public GuidePostsInfo load(GuidePostsKey statsKey) throws Exception {
        return this.statsLoader.loadStats(statsKey);
    }

    public ListenableFuture<GuidePostsInfo> reload(final GuidePostsKey key, final GuidePostsInfo prevGuidepostInfo) {
        if (this.statsLoader.needsLoad()) {
            ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<GuidePostsInfo>(){

                @Override
                public GuidePostsInfo call() {
                    try {
                        return PhoenixStatsCacheLoader.this.statsLoader.loadStats(key, prevGuidepostInfo);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to load stats from table: " + key.toString(), (Throwable)e);
                        return prevGuidepostInfo;
                    }
                }
            });
            executor.execute((Runnable)task);
            return task;
        }
        return Futures.immediateFuture((Object)prevGuidepostInfo);
    }
}

