/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import net.jcip.annotations.Immutable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.PName;

@Immutable
public class PNameImpl
implements PName {
    private PNameImplData data = new PNameImplData();

    @Override
    public int getEstimatedSize() {
        return 124 + this.data.stringName.length() * 2 + this.data.bytesName.length;
    }

    PNameImpl(String name) {
        this.data.stringName = name;
        this.data.bytesName = Bytes.toBytes((String)name);
    }

    PNameImpl(byte[] name) {
        this.data.stringName = Bytes.toString((byte[])name);
        this.data.bytesName = name;
    }

    @Override
    public String getString() {
        return this.data.stringName;
    }

    @Override
    public byte[] getBytes() {
        return this.data.bytesName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ImmutableBytesPtr getBytesPtr() {
        if (this.data.ptr != null) return this.data.ptr;
        byte[] byArray = this.data.bytesName;
        synchronized (this.data.bytesName) {
            if (this.data.ptr != null) return this.data.ptr;
            this.data.ptr = new ImmutableBytesPtr(this.data.bytesName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.data.ptr;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.data.stringName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PName)) {
            return false;
        }
        PName other = (PName)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        return this.getString().equals(other.getString());
    }

    public String toString() {
        return this.data.stringName;
    }

    private static class PNameImplData {
        public String stringName;
        public byte[] bytesName;
        public ImmutableBytesPtr ptr;
    }
}

