/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.runtime;

import com.google.inject.Module;
import java.lang.management.ManagementFactory;
import org.apache.tephra.runtime.TransactionDistributedModule;
import org.apache.tephra.runtime.TransactionInMemoryModule;
import org.apache.tephra.runtime.TransactionLocalModule;

public class TransactionModules {
    private final String clientId;

    public TransactionModules(String clientId) {
        this.clientId = clientId;
    }

    public TransactionModules() {
        this(ManagementFactory.getRuntimeMXBean().getName());
    }

    public Module getInMemoryModules() {
        return new TransactionInMemoryModule(this.clientId);
    }

    public Module getSingleNodeModules() {
        return new TransactionLocalModule(this.clientId);
    }

    public Module getDistributedModules() {
        return new TransactionDistributedModule(this.clientId);
    }
}

