/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.transaction.HBaseTransaction;
import org.apache.omid.transaction.SnapshotFilter;

public class AttributeSetSnapshotFilter
implements SnapshotFilter {
    private Table table;

    public AttributeSetSnapshotFilter(Table table) {
        this.table = table;
    }

    private TSOProto.Transaction.Builder getBuilder(HBaseTransaction transaction) {
        return TSOProto.Transaction.newBuilder().setTimestamp(transaction.getTransactionId()).setReadTimestamp(transaction.getReadTimestamp()).setVisibilityLevel(transaction.getVisibilityLevel().ordinal()).setEpoch(transaction.getEpoch());
    }

    @Override
    public Result get(Get get, HBaseTransaction transaction) throws IOException {
        get.setAttribute("__OMID_TRANSACTION__", this.getBuilder(transaction).build().toByteArray());
        get.setAttribute("__OMID_CLIENT_GET__", Bytes.toBytes((boolean)true));
        get.setAttribute("__OMID_LL__", Bytes.toBytes((boolean)transaction.isLowLatency()));
        return this.table.get(get);
    }

    @Override
    public ResultScanner getScanner(Scan scan, HBaseTransaction transaction) throws IOException {
        scan.setAttribute("__OMID_TRANSACTION__", this.getBuilder(transaction).build().toByteArray());
        scan.setAttribute("__OMID_LL__", Bytes.toBytes((boolean)transaction.isLowLatency()));
        return this.table.getScanner(scan);
    }

    @Override
    public void close() throws IOException {
        this.table.close();
    }
}

