/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.MetricsUtils;
import org.apache.omid.tso.MonitoringContext;
import org.apache.phoenix.thirdparty.com.google.common.base.Stopwatch;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MonitoringContextImpl
implements MonitoringContext {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringContextImpl.class);
    private volatile boolean flag;
    private Map<String, Long> elapsedTimeMsMap = new ConcurrentHashMap<String, Long>();
    private Map<String, Stopwatch> timers = new ConcurrentHashMap<String, Stopwatch>();
    private MetricsRegistry metrics;

    public MonitoringContextImpl(MetricsRegistry metrics) {
        this.metrics = metrics;
    }

    @Override
    public void timerStart(String name) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.timers.put(name, stopwatch);
    }

    @Override
    public void timerStop(String name) {
        if (this.flag) {
            LOG.warn("timerStop({}) called after publish. Measurement was ignored. {}", (Object)name, (Object)Throwables.getStackTraceAsString((Throwable)new Exception()));
            return;
        }
        Stopwatch activeStopwatch = this.timers.get(name);
        if (activeStopwatch == null) {
            throw new IllegalStateException(String.format("There is no %s timer in the %s monitoring context.", name, this));
        }
        activeStopwatch.stop();
        this.elapsedTimeMsMap.put(name, activeStopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.timers.remove(name);
    }

    @Override
    public void publish() {
        this.flag = true;
        for (Map.Entry<String, Long> entry : this.elapsedTimeMsMap.entrySet()) {
            this.metrics.timer(MetricsUtils.name("tso", entry.getKey())).update(entry.getValue());
        }
    }
}

