/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.CountAggregator;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.SortOrder;

public abstract class BaseAggregator
extends BaseTerminalExpression
implements Aggregator {
    protected final SortOrder sortOrder;

    public BaseAggregator(SortOrder sortOrder) {
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        this.sortOrder = sortOrder;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public int getSize() {
        return 16;
    }

    ImmutableBytesWritable evalClientAggs(Aggregator clientAgg) {
        CountAggregator ca = (CountAggregator)clientAgg;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ca.evaluate(null, ptr);
        return ptr;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return null;
    }

    @Override
    public boolean trackSize() {
        return false;
    }
}

