/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ArrayElemRefExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;

public class ArrayAnyComparisonExpression
extends BaseCompoundExpression {
    public ArrayAnyComparisonExpression() {
    }

    public ArrayAnyComparisonExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression arrayKVExpression = (Expression)this.children.get(0);
        if (!arrayKVExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int length = PArrayDataType.getArrayLength(ptr, PDataType.fromTypeId(((Expression)this.children.get(0)).getDataType().getSqlType() - 3000), arrayKVExpression.getMaxLength());
        boolean elementAvailable = false;
        for (int i = 0; i < length; ++i) {
            Expression comparisonExpr = (Expression)this.children.get(1);
            Expression arrayElemRef = ((ComparisonExpression)comparisonExpr).getChildren().get(1);
            ((ArrayElemRefExpression)arrayElemRef).setIndex(i + 1);
            comparisonExpr.evaluate(tuple, ptr);
            if (this.expectedReturnResult(this.resultFound(ptr))) {
                return this.result();
            }
            elementAvailable = true;
        }
        return elementAvailable;
    }

    protected boolean resultFound(ImmutableBytesWritable ptr) {
        return Bytes.equals((byte[])ptr.get(), (byte[])PDataType.TRUE_BYTES);
    }

    protected boolean result() {
        return true;
    }

    protected boolean expectedReturnResult(boolean result) {
        return true == result;
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }
}

