/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.PrefixFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBinaryBase;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;

@FunctionParseNode.BuiltInFunction(name="GET_BIT", args={@FunctionParseNode.Argument(allowedTypes={PBinary.class, PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PInteger.class})})
public class GetBitFunction
extends PrefixFunction {
    public static final String NAME = "GET_BIT";
    private Integer offsetPreCompute;

    public GetBitFunction() {
    }

    public GetBitFunction(List<Expression> children) throws SQLException {
        super(children);
        this.init();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int offset;
        if (this.offsetPreCompute == null) {
            Expression offsetExpr = (Expression)this.children.get(1);
            if (!offsetExpr.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            offset = (Integer)PInteger.INSTANCE.toObject(ptr, offsetExpr.getSortOrder());
        } else {
            offset = this.offsetPreCompute;
        }
        Expression dataExpr = (Expression)this.children.get(0);
        if (!dataExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int len = ptr.getLength() * 8;
        offset = (offset % len + len) % len;
        ((PBinaryBase)dataExpr.getDataType()).getBit(ptr, dataExpr.getSortOrder(), offset, ptr);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }

    private void init() {
        Expression offsetExpr = (Expression)this.children.get(1);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        this.offsetPreCompute = offsetExpr.isStateless() && offsetExpr.getDeterminism() == Determinism.ALWAYS && offsetExpr.evaluate(null, ptr) ? (Integer)PInteger.INSTANCE.toObject(ptr, offsetExpr.getSortOrder()) : null;
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return this.offsetPreCompute != null && this.offsetPreCompute == 0 ? FunctionExpression.OrderPreserving.YES_IF_LAST : FunctionExpression.OrderPreserving.NO;
    }
}

