/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.phoenix.compat.hbase.CompatRegionCoprocessorEnvironment;
import org.apache.phoenix.iterate.NonAggregateRegionScannerFactory;
import org.apache.phoenix.iterate.RegionScannerFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.schema.stats.DefaultStatisticsCollector;
import org.apache.phoenix.schema.stats.NoOpStatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsWriter;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotScanner
extends AbstractClientScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotScanner.class);
    private final Scan scan;
    private RegionScanner scanner;
    private HRegion region;
    private List<Cell> values;
    private StatisticsCollector statisticsCollector;

    public SnapshotScanner(Configuration conf, FileSystem fs, Path rootDir, HTableDescriptor htd, HRegionInfo hri, Scan scan) throws Throwable {
        LOGGER.info("Creating SnapshotScanner for region: " + hri);
        scan.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
        this.values = new ArrayList<Cell>();
        this.region = HRegion.openHRegion((Configuration)conf, (FileSystem)fs, (Path)rootDir, (HRegionInfo)hri, (HTableDescriptor)htd, null, null, null);
        this.scan = scan;
        RegionCoprocessorEnvironment snapshotEnv = this.getSnapshotContextEnvironment(conf);
        if (ScanUtil.isAnalyzeTable(scan)) {
            this.scanner = this.region.getScanner(scan);
            PhoenixConnection connection = (PhoenixConnection)ConnectionUtil.getInputConnection(conf, new Properties());
            String tableName = this.region.getTableDesc().getNameAsString();
            TableName physicalTableName = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, conf);
            HTableInterface table = connection.getQueryServices().getTable(physicalTableName.getName());
            StatisticsWriter statsWriter = StatisticsWriter.newWriter(connection, tableName, Long.MAX_VALUE);
            this.statisticsCollector = new DefaultStatisticsCollector(conf, (Region)this.region, tableName, null, null, null, statsWriter, (Table)table);
        } else if (scan.getAttribute("_NonAggregateQuery") != null) {
            NonAggregateRegionScannerFactory regionScannerFactory = new NonAggregateRegionScannerFactory(snapshotEnv);
            this.scanner = ((RegionScannerFactory)regionScannerFactory).getRegionScanner(scan, this.region.getScanner(scan));
            this.statisticsCollector = new NoOpStatisticsCollector();
        } else {
            throw new UnsupportedOperationException("Snapshot M/R jobs not available for aggregate queries");
        }
        this.statisticsCollector.init();
        this.region.startRegionOperation();
    }

    public Result next() throws IOException {
        this.values.clear();
        this.scanner.nextRaw(this.values);
        this.statisticsCollector.collectStatistics(this.values);
        if (this.values.isEmpty()) {
            return null;
        }
        return Result.create(this.values);
    }

    public void close() {
        if (this.scanner != null) {
            try {
                this.statisticsCollector.updateStatistics((Region)this.region, this.scan);
                this.scanner.close();
                this.scanner = null;
            }
            catch (IOException e) {
                LOGGER.warn("Exception while closing scanner", (Throwable)e);
            }
        }
        if (this.region != null) {
            try {
                this.region.closeRegionOperation();
                this.region.close(true);
                this.region = null;
            }
            catch (IOException e) {
                LOGGER.warn("Exception while closing scanner", (Throwable)e);
            }
        }
    }

    public boolean renewLease() {
        return false;
    }

    private RegionCoprocessorEnvironment getSnapshotContextEnvironment(final Configuration conf) {
        return new CompatRegionCoprocessorEnvironment(){

            public Region getRegion() {
                return SnapshotScanner.this.region;
            }

            public HRegionInfo getRegionInfo() {
                return SnapshotScanner.this.region.getRegionInfo();
            }

            public RegionServerServices getRegionServerServices() {
                throw new UnsupportedOperationException();
            }

            public ConcurrentMap<String, Object> getSharedData() {
                throw new UnsupportedOperationException();
            }

            public int getVersion() {
                throw new UnsupportedOperationException();
            }

            public String getHBaseVersion() {
                throw new UnsupportedOperationException();
            }

            public Coprocessor getInstance() {
                throw new UnsupportedOperationException();
            }

            public int getPriority() {
                throw new UnsupportedOperationException();
            }

            public int getLoadSequence() {
                throw new UnsupportedOperationException();
            }

            public Configuration getConfiguration() {
                return conf;
            }

            public HTableInterface getTable(TableName tableName) throws IOException {
                throw new UnsupportedOperationException();
            }

            public HTableInterface getTable(TableName tableName, ExecutorService executorService) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ClassLoader getClassLoader() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

