/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import com.google.common.collect.ImmutableMap;
import com.lmax.disruptor.EventTranslator;
import java.util.Map;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.log.QueryLogInfo;
import org.apache.phoenix.log.RingBufferEvent;
import org.apache.phoenix.monitoring.MetricType;

class RingBufferEventTranslator
implements EventTranslator<RingBufferEvent> {
    private String queryId;
    private ImmutableMap<QueryLogInfo, Object> queryInfo;
    private LogLevel connectionLogLevel;
    private Map<String, Map<MetricType, Long>> readMetrics;
    private Map<MetricType, Long> overAllMetrics;

    public RingBufferEventTranslator(String queryId) {
        this.queryId = queryId;
    }

    @Override
    public void translateTo(RingBufferEvent event, long sequence) {
        event.setQueryId(this.queryId);
        event.setQueryInfo(this.queryInfo);
        event.setReadMetrics(this.readMetrics);
        event.setOverAllMetrics(this.overAllMetrics);
        event.setConnectionLogLevel(this.connectionLogLevel);
        this.clear();
    }

    private void clear() {
        this.setQueryInfo(null, null, null, null);
    }

    public void setQueryInfo(LogLevel logLevel, ImmutableMap<QueryLogInfo, Object> queryInfo, Map<String, Map<MetricType, Long>> readMetrics, Map<MetricType, Long> overAllMetrics) {
        this.queryInfo = queryInfo;
        this.connectionLogLevel = logLevel;
        this.readMetrics = readMetrics;
        this.overAllMetrics = overAllMetrics;
    }
}

