/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;

public class CsvBulkImportUtil {
    public static void initCsvImportJob(Configuration conf, char fieldDelimiter, Character quoteChar, Character escapeChar, String arrayDelimiter, String binaryEncoding) {
        CsvBulkImportUtil.setChar(conf, "phoenix.mapreduce.import.fielddelimiter", Character.valueOf(fieldDelimiter));
        CsvBulkImportUtil.setChar(conf, "phoenix.mapreduce.import.quotechar", quoteChar);
        CsvBulkImportUtil.setChar(conf, "phoenix.mapreduce.import.escapechar", escapeChar);
        if (arrayDelimiter != null) {
            conf.set("phoenix.mapreduce.import.arraydelimiter", arrayDelimiter);
        }
        if (binaryEncoding != null) {
            conf.set("phoenix.upload.binaryDataType.encoding", binaryEncoding);
        }
    }

    public static void configurePreUpsertProcessor(Configuration conf, Class<? extends ImportPreUpsertKeyValueProcessor> processorClass) {
        conf.setClass("phoenix.mapreduce.import.kvprocessor", processorClass, ImportPreUpsertKeyValueProcessor.class);
    }

    @VisibleForTesting
    static void setChar(Configuration conf, String confKey, Character charValue) {
        if (charValue != null) {
            conf.set(confKey, Base64.encodeBytes((byte[])charValue.toString().getBytes()));
        }
    }

    @VisibleForTesting
    static Character getCharacter(Configuration conf, String confKey) {
        String strValue = conf.get(confKey);
        if (strValue == null) {
            return null;
        }
        return Character.valueOf(new String(Base64.decode((String)strValue)).charAt(0));
    }

    public static Path getOutputPath(Path outputdir, String tableName) {
        return new Path(outputdir, tableName.replace(":", "."));
    }
}

