/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.mapreduce.AbstractBulkLoadTool;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.CsvToKeyValueMapper;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.util.ColumnInfo;

public class CsvBulkLoadTool
extends AbstractBulkLoadTool {
    static final Option DELIMITER_OPT = new Option("d", "delimiter", true, "Input delimiter, defaults to comma");
    static final Option QUOTE_OPT = new Option("q", "quote", true, "Supply a custom phrase delimiter, defaults to double quote character");
    static final Option ESCAPE_OPT = new Option("e", "escape", true, "Supply a custom escape character, default is a backslash");
    static final Option ARRAY_DELIMITER_OPT = new Option("a", "array-delimiter", true, "Array element delimiter (optional)");
    static final Option binaryEncodingOption = new Option("b", "binaryEncoding", true, "Specifies binary encoding");

    @Override
    protected Options getOptions() {
        Options options = super.getOptions();
        options.addOption(DELIMITER_OPT);
        options.addOption(QUOTE_OPT);
        options.addOption(ESCAPE_OPT);
        options.addOption(ARRAY_DELIMITER_OPT);
        options.addOption(binaryEncodingOption);
        return options;
    }

    @Override
    protected void configureOptions(CommandLine cmdLine, List<ColumnInfo> importColumns, Configuration conf) throws SQLException {
        Character delimiterChar = Character.valueOf(',');
        if (cmdLine.hasOption(DELIMITER_OPT.getOpt())) {
            String delimString = StringEscapeUtils.unescapeJava((String)cmdLine.getOptionValue(DELIMITER_OPT.getOpt()));
            if (delimString.length() != 1) {
                throw new IllegalArgumentException("Illegal delimiter character: " + delimString);
            }
            delimiterChar = Character.valueOf(delimString.charAt(0));
        }
        Character quoteChar = Character.valueOf('\"');
        if (cmdLine.hasOption(QUOTE_OPT.getOpt())) {
            String quoteString = StringEscapeUtils.unescapeJava((String)cmdLine.getOptionValue(QUOTE_OPT.getOpt()));
            if (quoteString.length() == 0) {
                quoteChar = null;
            } else {
                if (quoteString.length() != 1) {
                    throw new IllegalArgumentException("Illegal quote character: " + quoteString);
                }
                quoteChar = Character.valueOf(quoteString.charAt(0));
            }
        }
        Character escapeChar = Character.valueOf('\\');
        if (cmdLine.hasOption(ESCAPE_OPT.getOpt())) {
            String escapeString = cmdLine.getOptionValue(ESCAPE_OPT.getOpt());
            if (escapeString.length() == 0) {
                escapeChar = null;
            } else {
                if (escapeString.length() != 1) {
                    throw new IllegalArgumentException("Illegal escape character: " + escapeString);
                }
                escapeChar = Character.valueOf(escapeString.charAt(0));
            }
        }
        String binaryEncoding = null;
        if (cmdLine.hasOption(binaryEncodingOption.getOpt())) {
            binaryEncoding = cmdLine.getOptionValue(binaryEncodingOption.getOpt());
        }
        CsvBulkImportUtil.initCsvImportJob(conf, delimiterChar.charValue(), quoteChar, escapeChar, cmdLine.getOptionValue(ARRAY_DELIMITER_OPT.getOpt()), binaryEncoding);
    }

    @Override
    protected void setupJob(Job job) {
        if (job.getJar() == null) {
            job.setJarByClass(CsvToKeyValueMapper.class);
        }
        job.setMapperClass(CsvToKeyValueMapper.class);
    }

    public static void main(String[] args) throws Exception {
        int exitStatus = ToolRunner.run((Tool)new CsvBulkLoadTool(), (String[])args);
        System.exit(exitStatus);
    }
}

