/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.phoenix.mapreduce.util.ViewInfoTracker;
import org.apache.phoenix.mapreduce.util.ViewInfoWritable;

public class PhoenixMultiViewInputSplit
extends InputSplit
implements Writable {
    List<ViewInfoWritable> viewInfoTrackerList;

    public PhoenixMultiViewInputSplit() {
        this.viewInfoTrackerList = new ArrayList<ViewInfoWritable>();
    }

    public PhoenixMultiViewInputSplit(List<ViewInfoWritable> viewInfoTracker) {
        this.viewInfoTrackerList = viewInfoTracker;
    }

    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)this.viewInfoTrackerList.size());
        for (ViewInfoWritable viewInfoWritable : this.viewInfoTrackerList) {
            if (!(viewInfoWritable instanceof ViewInfoTracker)) continue;
            viewInfoWritable.write(output);
        }
    }

    public void readFields(DataInput input) throws IOException {
        int count = WritableUtils.readVInt((DataInput)input);
        for (int i = 0; i < count; ++i) {
            ViewInfoTracker viewInfoTracker = new ViewInfoTracker();
            viewInfoTracker.readFields(input);
            this.viewInfoTrackerList.add(viewInfoTracker);
        }
    }

    public long getLength() {
        return 0L;
    }

    public String[] getLocations() {
        return new String[0];
    }

    public List<ViewInfoWritable> getViewInfoTrackerList() {
        return this.viewInfoTrackerList;
    }
}

