/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;

public class ConnectionUtil {
    public static Connection getInputConnection(Configuration conf) throws SQLException {
        return ConnectionUtil.getInputConnection(conf, new Properties());
    }

    public static Connection getInputConnection(Configuration conf, Properties props) throws SQLException {
        Preconditions.checkNotNull((Object)conf);
        return ConnectionUtil.getConnection(PhoenixConfigurationUtil.getInputCluster(conf), PhoenixConfigurationUtil.getClientPort(conf), PhoenixConfigurationUtil.getZNodeParent(conf), PropertiesUtil.combineProperties(props, conf));
    }

    public static Connection getOutputConnection(Configuration conf) throws SQLException {
        return ConnectionUtil.getOutputConnection(conf, new Properties());
    }

    public static Connection getOutputConnectionWithoutTheseProps(Configuration conf, Set<String> ignoreTheseProps) throws SQLException {
        return ConnectionUtil.getOutputConnection(conf, new Properties(), ignoreTheseProps);
    }

    public static Connection getOutputConnection(Configuration conf, Properties props) throws SQLException {
        return ConnectionUtil.getOutputConnection(conf, props, Collections.emptySet());
    }

    public static Connection getOutputConnection(Configuration conf, Properties props, Set<String> withoutTheseProps) throws SQLException {
        Preconditions.checkNotNull((Object)conf);
        return ConnectionUtil.getConnection(PhoenixConfigurationUtil.getOutputCluster(conf), PhoenixConfigurationUtil.getClientPort(conf), PhoenixConfigurationUtil.getZNodeParent(conf), PropertiesUtil.combineProperties(props, conf, withoutTheseProps));
    }

    private static Connection getConnection(String quorum, Integer clientPort, String znodeParent, Properties props) throws SQLException {
        Preconditions.checkNotNull((Object)quorum);
        return DriverManager.getConnection(QueryUtil.getUrl(quorum, clientPort, znodeParent), props);
    }
}

