/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.ReadMetricQueue;

public class TaskExecutionMetricsHolder {
    private final CombinableMetric taskQueueWaitTime;
    private final CombinableMetric taskEndToEndTime;
    private final CombinableMetric taskExecutionTime;
    private final CombinableMetric numTasks;
    private final CombinableMetric numRejectedTasks;
    public static final TaskExecutionMetricsHolder NO_OP_INSTANCE = new TaskExecutionMetricsHolder(new ReadMetricQueue(false, LogLevel.OFF), "");

    public TaskExecutionMetricsHolder(ReadMetricQueue readMetrics, String tableName) {
        this.taskQueueWaitTime = readMetrics.allotMetric(MetricType.TASK_QUEUE_WAIT_TIME, tableName);
        this.taskEndToEndTime = readMetrics.allotMetric(MetricType.TASK_END_TO_END_TIME, tableName);
        this.taskExecutionTime = readMetrics.allotMetric(MetricType.TASK_EXECUTION_TIME, tableName);
        this.numTasks = readMetrics.allotMetric(MetricType.TASK_EXECUTED_COUNTER, tableName);
        this.numRejectedTasks = readMetrics.allotMetric(MetricType.TASK_REJECTED_COUNTER, tableName);
    }

    public CombinableMetric getTaskQueueWaitTime() {
        return this.taskQueueWaitTime;
    }

    public CombinableMetric getTaskEndToEndTime() {
        return this.taskEndToEndTime;
    }

    public CombinableMetric getTaskExecutionTime() {
        return this.taskExecutionTime;
    }

    public CombinableMetric getNumTasks() {
        return this.numTasks;
    }

    public CombinableMetric getNumRejectedTasks() {
        return this.numRejectedTasks;
    }
}

