/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.OrderPreservingTracker;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.expression.visitor.StatelessTraverseNoExpressionVisitor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ProjectedColumn;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static boolean isConstant(Expression expression) {
        return expression.isStateless() && ExpressionUtil.isContantForStatement(expression);
    }

    public static boolean isContantForStatement(Expression expression) {
        return expression.getDeterminism() == Determinism.ALWAYS || expression.getDeterminism() == Determinism.PER_STATEMENT;
    }

    public static LiteralExpression getConstantExpression(Expression expression, ImmutableBytesWritable ptr) throws SQLException {
        Object value = null;
        PDataType type = expression.getDataType();
        if (expression.evaluate(null, ptr) && ptr.getLength() != 0) {
            value = type.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), type, expression.getSortOrder(), expression.getMaxLength(), expression.getScale());
        }
        return LiteralExpression.newConstant(value, type, expression.getDeterminism());
    }

    public static boolean isNull(Expression expression, ImmutableBytesWritable ptr) {
        return ExpressionUtil.isConstant(expression) && (!expression.evaluate(null, ptr) || ptr.getLength() == 0);
    }

    public static LiteralExpression getNullExpression(Expression expression) throws SQLException {
        return LiteralExpression.newConstant(null, expression.getDataType(), expression.getDeterminism());
    }

    public static boolean evaluatesToTrue(Expression expression) {
        if (ExpressionUtil.isConstant(expression)) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            expression.evaluate(null, ptr);
            return Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr));
        }
        return false;
    }

    public static boolean isPkPositionChanging(TableRef tableRef, List<Expression> projectedExpressions) throws SQLException {
        for (int i = 0; i < tableRef.getTable().getPKColumns().size(); ++i) {
            PColumn column = tableRef.getTable().getPKColumns().get(i);
            Expression source = projectedExpressions.get(i);
            if (source != null && source.equals(new ColumnRef(tableRef, column.getPosition()).newColumnExpression())) continue;
            return true;
        }
        return false;
    }

    public static boolean isColumnExpressionConstant(ColumnExpression columnExpression, Expression whereExpression) {
        if (whereExpression == null) {
            return false;
        }
        IsColumnConstantExpressionVisitor isColumnConstantExpressionVisitor = new IsColumnConstantExpressionVisitor(columnExpression);
        whereExpression.accept(isColumnConstantExpressionVisitor);
        return isColumnConstantExpressionVisitor.isConstant();
    }

    public static Pair<OrderByCompiler.OrderBy, Integer> getOrderByFromTable(TableRef tableRef, PhoenixConnection phoenixConnection, boolean orderByReverse) throws SQLException {
        PTable table = tableRef.getTable();
        Pair<OrderByCompiler.OrderBy, Integer> orderByAndRowKeyColumnOffset = ExpressionUtil.getOrderByFromTableByRowKeyColumn(table, phoenixConnection, orderByReverse);
        if (orderByAndRowKeyColumnOffset.getFirst() != OrderByCompiler.OrderBy.EMPTY_ORDER_BY) {
            return orderByAndRowKeyColumnOffset;
        }
        if (table.getType() == PTableType.PROJECTED && (orderByAndRowKeyColumnOffset = ExpressionUtil.getOrderByFromProjectedTable(tableRef, phoenixConnection, orderByReverse)).getFirst() != OrderByCompiler.OrderBy.EMPTY_ORDER_BY) {
            return orderByAndRowKeyColumnOffset;
        }
        return new Pair((Object)OrderByCompiler.OrderBy.EMPTY_ORDER_BY, (Object)0);
    }

    public static Pair<OrderByCompiler.OrderBy, Integer> getOrderByFromTableByRowKeyColumn(PTable table, PhoenixConnection phoenixConnection, boolean orderByReverse) {
        Pair<List<RowKeyColumnExpression>, Integer> rowKeyColumnExpressionsAndRowKeyColumnOffset = ExpressionUtil.getRowKeyColumnExpressionsFromTable(table, phoenixConnection);
        List rowKeyColumnExpressions = (List)rowKeyColumnExpressionsAndRowKeyColumnOffset.getFirst();
        int rowKeyColumnOffset = (Integer)rowKeyColumnExpressionsAndRowKeyColumnOffset.getSecond();
        if (rowKeyColumnExpressions.isEmpty()) {
            return new Pair((Object)OrderByCompiler.OrderBy.EMPTY_ORDER_BY, (Object)0);
        }
        return new Pair((Object)ExpressionUtil.convertRowKeyColumnExpressionsToOrderBy(rowKeyColumnExpressions, orderByReverse), (Object)rowKeyColumnOffset);
    }

    public static Pair<OrderByCompiler.OrderBy, Integer> getOrderByFromProjectedTable(TableRef projectedTableRef, PhoenixConnection phoenixConnection, boolean orderByReverse) throws SQLException {
        ColumnRef projectedColumnRef;
        PTable projectedTable = projectedTableRef.getTable();
        assert (projectedTable.getType() == PTableType.PROJECTED);
        TableRef sourceTableRef = null;
        TreeMap<Integer, ColumnRef> sourceRowKeyColumnIndexToProjectedColumnRef = new TreeMap<Integer, ColumnRef>();
        for (PColumn column : projectedTable.getColumns()) {
            int sourceRowKeyColumnIndex;
            if (!(column instanceof ProjectedColumn)) continue;
            ProjectedColumn projectedColumn = (ProjectedColumn)column;
            ColumnRef sourceColumnRef = projectedColumn.getSourceColumnRef();
            TableRef currentSourceTableRef = sourceColumnRef.getTableRef();
            if (sourceTableRef == null) {
                sourceTableRef = currentSourceTableRef;
            } else if (!sourceTableRef.equals(currentSourceTableRef)) {
                return new Pair((Object)OrderByCompiler.OrderBy.EMPTY_ORDER_BY, (Object)0);
            }
            if ((sourceRowKeyColumnIndex = sourceColumnRef.getPKSlotPosition()) < 0) continue;
            projectedColumnRef = new ColumnRef(projectedTableRef, projectedColumn.getPosition());
            sourceRowKeyColumnIndexToProjectedColumnRef.put(sourceRowKeyColumnIndex, projectedColumnRef);
        }
        if (sourceTableRef == null) {
            return new Pair((Object)OrderByCompiler.OrderBy.EMPTY_ORDER_BY, (Object)0);
        }
        int sourceRowKeyColumnOffset = ExpressionUtil.getRowKeyColumnOffset(sourceTableRef.getTable(), phoenixConnection);
        LinkedList<OrderByExpression> orderByExpressions = new LinkedList<OrderByExpression>();
        int matchedSourceRowKeyColumnOffset = sourceRowKeyColumnOffset;
        for (Map.Entry entry : sourceRowKeyColumnIndexToProjectedColumnRef.entrySet()) {
            int currentRowKeyColumnOffset = (Integer)entry.getKey();
            if (currentRowKeyColumnOffset < matchedSourceRowKeyColumnOffset) continue;
            if (currentRowKeyColumnOffset != matchedSourceRowKeyColumnOffset) break;
            ++matchedSourceRowKeyColumnOffset;
            projectedColumnRef = (ColumnRef)entry.getValue();
            Expression projectedValueColumnExpression = projectedColumnRef.newColumnExpression();
            OrderByExpression orderByExpression = OrderByExpression.convertExpressionToOrderByExpression(projectedValueColumnExpression, orderByReverse);
            orderByExpressions.add(orderByExpression);
        }
        if (orderByExpressions.isEmpty()) {
            return new Pair((Object)OrderByCompiler.OrderBy.EMPTY_ORDER_BY, (Object)0);
        }
        return new Pair((Object)new OrderByCompiler.OrderBy(orderByExpressions), (Object)sourceRowKeyColumnOffset);
    }

    public static int getRowKeyColumnOffset(PTable table, PhoenixConnection phoenixConnection) {
        boolean isSalted = table.getBucketNum() != null;
        boolean isMultiTenant = phoenixConnection.getTenantId() != null && table.isMultiTenant();
        boolean isSharedViewIndex = table.getViewIndexId() != null;
        return (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
    }

    public static Pair<List<RowKeyColumnExpression>, Integer> getRowKeyColumnExpressionsFromTable(PTable table, PhoenixConnection phoenixConnection) {
        List<PColumn> pkColumns;
        int pkPositionOffset = ExpressionUtil.getRowKeyColumnOffset(table, phoenixConnection);
        if (pkPositionOffset >= (pkColumns = table.getPKColumns()).size()) {
            return new Pair(Collections.emptyList(), (Object)0);
        }
        ArrayList<RowKeyColumnExpression> rowKeyColumnExpressions = new ArrayList<RowKeyColumnExpression>(pkColumns.size() - pkPositionOffset);
        for (int index = pkPositionOffset; index < pkColumns.size(); ++index) {
            RowKeyColumnExpression rowKeyColumnExpression = new RowKeyColumnExpression(pkColumns.get(index), new RowKeyValueAccessor(pkColumns, index));
            rowKeyColumnExpressions.add(rowKeyColumnExpression);
        }
        return new Pair(rowKeyColumnExpressions, (Object)pkPositionOffset);
    }

    public static OrderByCompiler.OrderBy convertRowKeyColumnExpressionsToOrderBy(List<RowKeyColumnExpression> rowKeyColumnExpressions, boolean orderByReverse) {
        return ExpressionUtil.convertRowKeyColumnExpressionsToOrderBy(rowKeyColumnExpressions, Collections.emptyList(), orderByReverse);
    }

    public static OrderByCompiler.OrderBy convertRowKeyColumnExpressionsToOrderBy(List<RowKeyColumnExpression> rowKeyColumnExpressions, List<OrderPreservingTracker.Info> orderPreservingTrackInfos, boolean orderByReverse) {
        if (rowKeyColumnExpressions.isEmpty()) {
            return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
        }
        ArrayList<OrderByExpression> orderByExpressions = new ArrayList<OrderByExpression>(rowKeyColumnExpressions.size());
        Iterator<OrderPreservingTracker.Info> orderPreservingTrackInfosIter = null;
        if (orderPreservingTrackInfos != null && orderPreservingTrackInfos.size() > 0) {
            if (orderPreservingTrackInfos.size() != rowKeyColumnExpressions.size()) {
                throw new IllegalStateException("orderPreservingTrackInfos.size():[" + orderPreservingTrackInfos.size() + "] should equals rowKeyColumnExpressions.size():[" + rowKeyColumnExpressions.size() + "]!");
            }
            orderPreservingTrackInfosIter = orderPreservingTrackInfos.iterator();
        }
        for (RowKeyColumnExpression rowKeyColumnExpression : rowKeyColumnExpressions) {
            OrderPreservingTracker.Info orderPreservingTrackInfo = null;
            if (orderPreservingTrackInfosIter != null) {
                assert (orderPreservingTrackInfosIter.hasNext());
                orderPreservingTrackInfo = orderPreservingTrackInfosIter.next();
            }
            OrderByExpression orderByExpression = OrderByExpression.convertExpressionToOrderByExpression(rowKeyColumnExpression, orderPreservingTrackInfo, orderByReverse);
            orderByExpressions.add(orderByExpression);
        }
        return new OrderByCompiler.OrderBy(orderByExpressions);
    }

    public static OrderByCompiler.OrderBy convertGroupByToOrderBy(GroupByCompiler.GroupBy groupBy, boolean orderByReverse) {
        if (groupBy.isEmpty()) {
            return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
        }
        List<RowKeyColumnExpression> rowKeyColumnExpressions = ExpressionUtil.convertGroupByToRowKeyColumnExpressions(groupBy);
        List<OrderPreservingTracker.Info> orderPreservingTrackInfos = Collections.emptyList();
        if (groupBy.isOrderPreserving()) {
            orderPreservingTrackInfos = groupBy.getOrderPreservingTrackInfos();
        }
        return ExpressionUtil.convertRowKeyColumnExpressionsToOrderBy(rowKeyColumnExpressions, orderPreservingTrackInfos, orderByReverse);
    }

    public static List<RowKeyColumnExpression> convertGroupByToRowKeyColumnExpressions(GroupByCompiler.GroupBy groupBy) {
        if (groupBy.isEmpty()) {
            return Collections.emptyList();
        }
        List<Expression> groupByExpressions = groupBy.getExpressions();
        ArrayList<RowKeyColumnExpression> rowKeyColumnExpressions = new ArrayList<RowKeyColumnExpression>(groupByExpressions.size());
        int columnIndex = 0;
        for (Expression groupByExpression : groupByExpressions) {
            RowKeyColumnExpression rowKeyColumnExpression = ExpressionUtil.convertGroupByExpressionToRowKeyColumnExpression(groupBy, groupByExpression, columnIndex++);
            rowKeyColumnExpressions.add(rowKeyColumnExpression);
        }
        return rowKeyColumnExpressions;
    }

    public static RowKeyColumnExpression convertGroupByExpressionToRowKeyColumnExpression(GroupByCompiler.GroupBy groupBy, Expression originalExpression, int groupByColumnIndex) {
        RowKeyValueAccessor rowKeyValueAccessor = new RowKeyValueAccessor(groupBy.getKeyExpressions(), groupByColumnIndex);
        return new RowKeyColumnExpression((PDatum)originalExpression, rowKeyValueAccessor, groupBy.getKeyExpressions().get(groupByColumnIndex).getDataType());
    }

    private static class IsCompositeLiteralExpressionVisitor
    extends StatelessTraverseAllExpressionVisitor<Boolean> {
        private IsCompositeLiteralExpressionVisitor() {
        }

        @Override
        public Boolean defaultReturn(Expression expression, List<Boolean> childResultValues) {
            if (!ExpressionUtil.isContantForStatement(expression) || childResultValues.size() < expression.getChildren().size()) {
                return Boolean.FALSE;
            }
            for (Boolean childResultValue : childResultValues) {
                if (childResultValue.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(LiteralExpression literalExpression) {
            return Boolean.TRUE;
        }
    }

    private static class IsColumnConstantExpressionVisitor
    extends StatelessTraverseNoExpressionVisitor<Void> {
        private final Expression columnExpression;
        private Expression firstRhsConstantExpression = null;
        private int rhsConstantCount = 0;
        private boolean isNullExpressionVisited = false;

        public IsColumnConstantExpressionVisitor(Expression columnExpression) {
            this.columnExpression = columnExpression;
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression andExpression) {
            if (this.rhsConstantCount > 1) {
                return null;
            }
            return andExpression.getChildren().iterator();
        }

        @Override
        public Iterator<Expression> visitEnter(ComparisonExpression comparisonExpression) {
            if (this.rhsConstantCount > 1) {
                return null;
            }
            if (comparisonExpression.getFilterOp() != CompareFilter.CompareOp.EQUAL) {
                return null;
            }
            Expression lhsExpresssion = comparisonExpression.getChildren().get(0);
            if (!this.columnExpression.equals(lhsExpresssion)) {
                return null;
            }
            Expression rhsExpression = comparisonExpression.getChildren().get(1);
            if (rhsExpression == null) {
                return null;
            }
            Boolean isConstant = rhsExpression.accept(new IsCompositeLiteralExpressionVisitor());
            if (isConstant != null && isConstant.booleanValue()) {
                this.checkConstantValue(rhsExpression);
            }
            return null;
        }

        public boolean isConstant() {
            return this.rhsConstantCount == 1;
        }

        @Override
        public Iterator<Expression> visitEnter(IsNullExpression isNullExpression) {
            if (this.rhsConstantCount > 1) {
                return null;
            }
            if (isNullExpression.isNegate()) {
                return null;
            }
            Expression lhsExpresssion = isNullExpression.getChildren().get(0);
            if (!this.columnExpression.equals(lhsExpresssion)) {
                return null;
            }
            this.checkConstantValue(null);
            return null;
        }

        private void checkConstantValue(Expression rhsExpression) {
            if (!this.isNullExpressionVisited && this.firstRhsConstantExpression == null) {
                this.firstRhsConstantExpression = rhsExpression;
                ++this.rhsConstantCount;
                if (rhsExpression == null) {
                    this.isNullExpressionVisited = true;
                }
                return;
            }
            if (!IsColumnConstantExpressionVisitor.isExpressionEquals(this.isNullExpressionVisited ? null : this.firstRhsConstantExpression, rhsExpression)) {
                ++this.rhsConstantCount;
                return;
            }
        }

        private static boolean isExpressionEquals(Expression oldExpression, Expression newExpression) {
            if (oldExpression == null) {
                if (newExpression == null) {
                    return true;
                }
                return ExpressionUtil.isNull(newExpression, new ImmutableBytesWritable());
            }
            if (newExpression == null) {
                return ExpressionUtil.isNull(oldExpression, new ImmutableBytesWritable());
            }
            return oldExpression.equals(newExpression);
        }
    }
}

