/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.txprune.hbase;

import java.text.DateFormat;
import java.util.Objects;
import java.util.SortedSet;

public class RegionsAtTime {
    private final long time;
    private final String timeAsString;
    private final SortedSet<String> regions;

    public RegionsAtTime(long time, SortedSet<String> regions, DateFormat dateFormat) {
        this.time = time;
        this.timeAsString = dateFormat.format(time);
        this.regions = regions;
    }

    public long getTime() {
        return this.time;
    }

    public String getTimeAsString() {
        return this.timeAsString;
    }

    public SortedSet<String> getRegions() {
        return this.regions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionsAtTime that = (RegionsAtTime)o;
        return this.time == that.time && Objects.equals(this.timeAsString, that.timeAsString) && Objects.equals(this.regions, that.regions);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.timeAsString, this.regions);
    }

    public String toString() {
        return "RegionsAtTime{time=" + this.time + ", timeAsString='" + this.getTimeAsString() + '\'' + ", regions=" + this.getRegions() + '}';
    }
}

