/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.apache.omid.tso.LongCache;

public class CacheEvaluation {
    private static final int ENTRIES = 1000000;
    private static final int WARMUP_ROUNDS = 2;
    private static final int ROUNDS = 4;
    private static final double HOT_PERC = 1.0;

    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
        int[] asoc;
        for (int anAsoc : asoc = new int[]{8, 16, 32}) {
            PrintWriter writer = new PrintWriter(anAsoc + ".out", "UTF-8");
            new CacheEvaluation().testEntriesAge(new LongCache(1000000, anAsoc), writer);
            writer.close();
        }
        PrintWriter writer = new PrintWriter("guava.out", "UTF-8");
        writer.close();
    }

    private void testEntriesAge(LongCache cache, PrintWriter writer) {
        int i;
        Random random = new Random();
        long seed = random.nextLong();
        writer.println("# Random seed: " + seed);
        random.setSeed(seed);
        int removals = 0;
        double tempStdDev = 0.0;
        double tempAvg = 0.0;
        int largestDeletedTimestamp = 0;
        long hotItem = random.nextLong();
        Runtime.getRuntime().gc();
        for (i = 0; i < 2000000; ++i) {
            long toInsert = (double)random.nextInt(100) < 1.0 ? hotItem : random.nextLong();
            long removed = cache.set(toInsert, i);
            if (removed > (long)largestDeletedTimestamp) {
                largestDeletedTimestamp = (int)removed;
            }
            if (removed > (long)largestDeletedTimestamp) {
                largestDeletedTimestamp = (int)removed;
            }
            if (i % 1000000 != 0) continue;
            int round = i / 1000000 + 1;
            System.err.format("Warmup [%d/%d]%n", round, 2);
        }
        long time = System.nanoTime();
        while (i < 6000000) {
            long toInsert = (double)random.nextInt(100) < 1.0 ? hotItem : random.nextLong();
            long removed = cache.set(toInsert, i);
            if (removed > (long)largestDeletedTimestamp) {
                largestDeletedTimestamp = (int)removed;
            }
            int gap = i - largestDeletedTimestamp;
            double oldAvg = tempAvg;
            tempAvg += ((double)gap - tempAvg) / (double)(++removals);
            tempStdDev += ((double)gap - oldAvg) * ((double)gap - tempAvg);
            if (i % 1000000 == 0) {
                int round = i / 1000000 - 2 + 1;
                System.err.format("Progress [%d/%d]%n", round, 4);
            }
            ++i;
        }
        long elapsed = System.nanoTime() - time;
        double elapsedSeconds = (double)elapsed / 1.0E9;
        long totalOps = 4000000L;
        writer.println("# Free mem before GC (MB) :" + (double)Runtime.getRuntime().freeMemory() / 1048576.0);
        Runtime.getRuntime().gc();
        writer.println("# Free mem (MB) :" + (double)Runtime.getRuntime().freeMemory() / 1048576.0);
        writer.println("# Elapsed (s): " + elapsedSeconds);
        writer.println("# Elapsed per 100 ops (ms): " + (double)elapsed / (double)totalOps / 100.0 / 1000000.0);
        writer.println("# Ops per s : " + (double)totalOps / elapsedSeconds);
        writer.println("# Avg gap: " + tempAvg);
        writer.println("# Std dev gap: " + Math.sqrt(tempStdDev / 1000000.0));
    }
}

