/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.apache.omid.tso.PersistenceProcessor;
import org.apache.omid.tso.PersistenceProcessorImpl;
import org.apache.omid.tso.PersitenceProcessorNullImpl;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.ReplyProcessorImpl;
import org.apache.omid.tso.RequestProcessor;
import org.apache.omid.tso.RequestProcessorPersistCT;
import org.apache.omid.tso.RequestProcessorSkipCT;
import org.apache.omid.tso.RetryProcessor;
import org.apache.omid.tso.RetryProcessorImpl;
import org.apache.omid.tso.TSOServerConfig;

public class DisruptorModule
extends AbstractModule {
    private final TSOServerConfig config;

    public DisruptorModule(TSOServerConfig config) {
        this.config = config;
    }

    protected void configure() {
        switch (this.config.getWaitStrategyEnum()) {
            case LOW_CPU: {
                this.bind(WaitStrategy.class).annotatedWith((Annotation)Names.named((String)"PersistenceStrategy")).to(BlockingWaitStrategy.class);
                this.bind(WaitStrategy.class).annotatedWith((Annotation)Names.named((String)"ReplyStrategy")).to(BlockingWaitStrategy.class);
                this.bind(WaitStrategy.class).annotatedWith((Annotation)Names.named((String)"RetryStrategy")).to(BlockingWaitStrategy.class);
                break;
            }
            default: {
                this.bind(WaitStrategy.class).annotatedWith((Annotation)Names.named((String)"PersistenceStrategy")).to(BusySpinWaitStrategy.class);
                this.bind(WaitStrategy.class).annotatedWith((Annotation)Names.named((String)"ReplyStrategy")).to(BusySpinWaitStrategy.class);
                this.bind(WaitStrategy.class).annotatedWith((Annotation)Names.named((String)"RetryStrategy")).to(YieldingWaitStrategy.class);
            }
        }
        if (this.config.getLowLatency().booleanValue()) {
            this.bind(RequestProcessor.class).to(RequestProcessorSkipCT.class).in(Singleton.class);
            this.bind(PersistenceProcessor.class).to(PersitenceProcessorNullImpl.class).in(Singleton.class);
        } else {
            this.bind(PersistenceProcessor.class).to(PersistenceProcessorImpl.class).in(Singleton.class);
            this.bind(RequestProcessor.class).to(RequestProcessorPersistCT.class).in(Singleton.class);
        }
        this.bind(ReplyProcessor.class).to(ReplyProcessorImpl.class).in(Singleton.class);
        this.bind(RetryProcessor.class).to(RetryProcessorImpl.class).in(Singleton.class);
    }
}

