/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.omid.metrics.Gauge;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.MetricsUtils;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.TimestampOracle;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TimestampOracleImpl
implements TimestampOracle {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampOracleImpl.class);
    static final long TIMESTAMP_BATCH = 500000000L;
    private static final long TIMESTAMP_REMAINING_THRESHOLD = 50000000L;
    private long lastTimestamp;
    private long maxTimestamp;
    private TimestampStorage storage;
    private Panicker panicker;
    private long nextAllocationThreshold;
    private volatile long maxAllocatedTimestamp;
    private Executor executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("ts-persist-%d").build());
    private Runnable allocateTimestampsBatchTask;

    @Inject
    public TimestampOracleImpl(MetricsRegistry metrics, TimestampStorage tsStorage, Panicker panicker) throws IOException {
        this.storage = tsStorage;
        this.panicker = panicker;
        metrics.gauge(MetricsUtils.name("tso", "maxTimestamp"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return TimestampOracleImpl.this.maxTimestamp;
            }
        });
    }

    @Override
    public void initialize() throws IOException {
        this.lastTimestamp = this.maxTimestamp = this.storage.getMaxTimestamp();
        this.allocateTimestampsBatchTask = new AllocateTimestampBatchTask(this.lastTimestamp);
        this.executor.execute(this.allocateTimestampsBatchTask);
        LOG.info("Initializing timestamp oracle with timestamp {}", (Object)this.lastTimestamp);
    }

    @Override
    public long next() {
        this.lastTimestamp += 50L;
        if (this.lastTimestamp >= this.nextAllocationThreshold) {
            this.nextAllocationThreshold = Long.MAX_VALUE;
            this.executor.execute(this.allocateTimestampsBatchTask);
        }
        if (this.lastTimestamp >= this.maxTimestamp) {
            assert (this.maxTimestamp <= this.maxAllocatedTimestamp);
            while (this.maxAllocatedTimestamp == this.maxTimestamp) {
            }
            assert (this.maxAllocatedTimestamp > this.maxTimestamp);
            this.maxTimestamp = this.maxAllocatedTimestamp;
            this.nextAllocationThreshold = this.maxTimestamp - 50000000L;
            assert (this.nextAllocationThreshold > this.lastTimestamp && this.nextAllocationThreshold < this.maxTimestamp);
            assert (this.lastTimestamp < this.maxTimestamp);
        }
        return this.lastTimestamp;
    }

    @Override
    public long getLast() {
        return this.lastTimestamp;
    }

    public String toString() {
        return String.format("TimestampOracle -> LastTimestamp: %d, MaxTimestamp: %d", this.lastTimestamp, this.maxTimestamp);
    }

    private class AllocateTimestampBatchTask
    implements Runnable {
        long previousMaxTimestamp;

        AllocateTimestampBatchTask(long previousMaxTimestamp) {
            this.previousMaxTimestamp = previousMaxTimestamp;
        }

        @Override
        public void run() {
            long newMaxTimestamp = this.previousMaxTimestamp + 500000000L;
            try {
                TimestampOracleImpl.this.storage.updateMaxTimestamp(this.previousMaxTimestamp, newMaxTimestamp);
                TimestampOracleImpl.this.maxAllocatedTimestamp = newMaxTimestamp;
                this.previousMaxTimestamp = newMaxTimestamp;
            }
            catch (Throwable e) {
                TimestampOracleImpl.this.panicker.panic("Can't store the new max timestamp", e);
            }
        }
    }

    @VisibleForTesting
    static class InMemoryTimestampStorage
    implements TimestampStorage {
        long maxTimestamp = 0L;

        InMemoryTimestampStorage() {
        }

        @Override
        public void updateMaxTimestamp(long previousMaxTimestamp, long nextMaxTimestamp) {
            this.maxTimestamp = nextMaxTimestamp;
            LOG.info("Updating max timestamp: (previous:{}, new:{})", (Object)previousMaxTimestamp, (Object)nextMaxTimestamp);
        }

        @Override
        public long getMaxTimestamp() {
            return this.maxTimestamp;
        }
    }
}

