/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.GlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.parallel.WaitForCompletionTaskRunner;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerRegionScanner
extends GlobalIndexRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexerRegionScanner.class);
    protected Map<byte[], Put> indexKeyToDataPutMap;
    protected UngroupedAggregateRegionObserver.MutationList mutations;
    private boolean partialRebuild = false;

    IndexerRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver) throws IOException {
        super(innerScanner, region, scan, env, ungroupedAggregateRegionObserver);
        this.indexHTable = this.hTableFactory.getTable(new ImmutableBytesPtr(this.indexMaintainer.getIndexTableName()));
        this.indexTableTTL = this.indexHTable.getTableDescriptor().getColumnFamilies()[0].getTimeToLive();
        this.pool = new WaitForCompletionTaskRunner(ThreadPoolManager.getExecutor(new ThreadPoolBuilder("IndexVerify", env.getConfiguration()).setMaxThread("index.verify.threads.max", 16).setCoreTimeout("index.writer.threads.keepalivetime"), env));
        if (scan.getAttribute("_IndexRebuildPaging") == null) {
            this.partialRebuild = true;
        }
        if (this.verify) {
            this.indexKeyToDataPutMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
            this.verificationResult = new IndexToolVerificationResult(scan);
            this.verificationResultRepository = new IndexVerificationResultRepository(this.indexMaintainer.getIndexTableName(), this.hTableFactory);
        } else {
            this.mutations = new UngroupedAggregateRegionObserver.MutationList(this.maxBatchSize);
        }
    }

    @Override
    public HRegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    @Override
    public boolean isFilterDone() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.innerScanner.close();
        try {
            if (this.verify) {
                this.verificationResultRepository.logToIndexToolResultTable(this.verificationResult, IndexTool.IndexVerifyType.ONLY, this.region.getRegionInfo().getRegionName());
            }
        }
        finally {
            this.pool.stop("IndexerRegionScanner is closing");
            this.hTableFactory.shutdown();
            this.indexHTable.close();
            if (this.verify) {
                this.verificationResultRepository.close();
            }
        }
    }

    private boolean verifySingleIndexRow(Result indexRow, Put dataRow, IndexToolVerificationResult.PhaseResult verificationPhaseResult) throws IOException {
        List cells;
        GlobalIndexRegionScanner.SimpleValueGetter valueGetter = new GlobalIndexRegionScanner.SimpleValueGetter(dataRow);
        long ts = IndexerRegionScanner.getMaxTimestamp((Mutation)dataRow);
        Put indexPut = this.indexMaintainer.buildUpdateMutation(GenericKeyValueBuilder.INSTANCE, valueGetter, new ImmutableBytesWritable(dataRow.getRow()), ts, null, null);
        if (indexPut == null) {
            indexPut = new Put(indexRow.getRow());
        }
        indexPut.addColumn(this.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), this.indexMaintainer.getEmptyKeyValueQualifier(), ts, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
        int cellCount = 0;
        long currentTime = EnvironmentEdgeManager.currentTime();
        Iterator iterator = indexPut.getFamilyCellMap().values().iterator();
        while (iterator.hasNext() && (cells = (List)iterator.next()) != null) {
            for (Cell expectedCell : cells) {
                byte[] qualifier;
                byte[] family = CellUtil.cloneFamily((Cell)expectedCell);
                Cell actualCell = indexRow.getColumnLatestCell(family, qualifier = CellUtil.cloneQualifier((Cell)expectedCell));
                if (actualCell == null) {
                    if (IndexerRegionScanner.isTimestampBeforeTTL(this.indexTableTTL, currentTime, expectedCell.getTimestamp())) continue;
                    return false;
                }
                if (actualCell.getTimestamp() < ts) continue;
                if (!CellUtil.matchingValue((Cell)actualCell, (Cell)expectedCell) || actualCell.getTimestamp() != ts) {
                    if (IndexerRegionScanner.isTimestampBeyondMaxLookBack(this.maxLookBackInMills, currentTime, actualCell.getTimestamp())) {
                        verificationPhaseResult.setBeyondMaxLookBackInvalidIndexRowCount(verificationPhaseResult.getBeyondMaxLookBackInvalidIndexRowCount() + 1L);
                        continue;
                    }
                    return false;
                }
                ++cellCount;
            }
        }
        return cellCount == indexRow.rawCells().length;
    }

    private void verifyIndexRows(List<KeyRange> keys, Map<byte[], Put> perTaskDataKeyToDataPutMap, IndexToolVerificationResult.PhaseResult verificationPhaseResult) throws IOException {
        ScanRanges scanRanges = ScanRanges.createPointLookup(keys);
        Scan indexScan = new Scan();
        indexScan.setTimeRange(this.scan.getTimeRange().getMin(), this.scan.getTimeRange().getMax());
        scanRanges.initializeScan(indexScan);
        SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
        indexScan.setFilter((Filter)skipScanFilter);
        indexScan.setCacheBlocks(false);
        try (ResultScanner resultScanner = this.indexHTable.getScanner(indexScan);){
            Result result = resultScanner.next();
            while (result != null) {
                Put dataPut = this.indexKeyToDataPutMap.get(result.getRow());
                if (dataPut == null) {
                    this.exceptionMessage = "Index verify failed - Missing data row - " + this.indexHTable.getName();
                    throw new IOException(this.exceptionMessage);
                }
                if (this.verifySingleIndexRow(result, dataPut, verificationPhaseResult)) {
                    verificationPhaseResult.setValidIndexRowCount(verificationPhaseResult.getValidIndexRowCount() + 1L);
                } else {
                    verificationPhaseResult.setInvalidIndexRowCount(verificationPhaseResult.getInvalidIndexRowCount() + 1L);
                }
                perTaskDataKeyToDataPutMap.remove(dataPut.getRow());
                result = resultScanner.next();
            }
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(this.indexHTable.getName().toString(), t);
        }
        if (!perTaskDataKeyToDataPutMap.isEmpty()) {
            Iterator<Map.Entry<byte[], Put>> itr = perTaskDataKeyToDataPutMap.entrySet().iterator();
            long currentTime = EnvironmentEdgeManager.currentTime();
            while (itr.hasNext()) {
                Map.Entry<byte[], Put> entry = itr.next();
                long ts = IndexerRegionScanner.getMaxTimestamp((Mutation)entry.getValue());
                if (!IndexerRegionScanner.isTimestampBeforeTTL(this.indexTableTTL, currentTime, ts)) continue;
                itr.remove();
                verificationPhaseResult.setExpiredIndexRowCount(verificationPhaseResult.getExpiredIndexRowCount() + 1L);
            }
        }
        if (!perTaskDataKeyToDataPutMap.isEmpty()) {
            for (Map.Entry<byte[], Put> entry : perTaskDataKeyToDataPutMap.entrySet()) {
                Put put = entry.getValue();
                long ts = IndexerRegionScanner.getMaxTimestamp((Mutation)put);
                long currentTime = EnvironmentEdgeManager.currentTime();
                if (IndexerRegionScanner.isTimestampBeyondMaxLookBack(this.maxLookBackInMills, currentTime, ts)) {
                    verificationPhaseResult.setBeyondMaxLookBackMissingIndexRowCount(verificationPhaseResult.getBeyondMaxLookBackMissingIndexRowCount() + 1L);
                    continue;
                }
                verificationPhaseResult.setMissingIndexRowCount(verificationPhaseResult.getMissingIndexRowCount() + 1L);
            }
        }
    }

    private void addVerifyTask(TaskBatch<Boolean> tasks, final List<KeyRange> keys, final Map<byte[], Put> perTaskDataKeyToDataPutMap, final IndexToolVerificationResult.PhaseResult verificationPhaseResult) {
        tasks.add(new Task<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (Thread.currentThread().isInterrupted()) {
                    IndexerRegionScanner.this.exceptionMessage = "Pool closed, not attempting to verify index rows! " + IndexerRegionScanner.this.indexHTable.getName();
                    throw new IOException(IndexerRegionScanner.this.exceptionMessage);
                }
                IndexerRegionScanner.this.verifyIndexRows(keys, perTaskDataKeyToDataPutMap, verificationPhaseResult);
                return Boolean.TRUE;
            }
        });
    }

    private void parallelizeIndexVerify(IndexToolVerificationResult.PhaseResult verificationPhaseResult) throws IOException {
        int taskCount = (this.indexKeyToDataPutMap.size() + this.rowCountPerTask - 1) / this.rowCountPerTask;
        TaskBatch<Boolean> tasks = new TaskBatch<Boolean>(taskCount);
        ArrayList<TreeMap> dataPutMapList = new ArrayList<TreeMap>(taskCount);
        ArrayList<IndexToolVerificationResult.PhaseResult> verificationPhaseResultList = new ArrayList<IndexToolVerificationResult.PhaseResult>(taskCount);
        ArrayList<KeyRange> keys = new ArrayList<KeyRange>(this.rowCountPerTask);
        TreeMap perTaskDataKeyToDataPutMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        dataPutMapList.add(perTaskDataKeyToDataPutMap);
        IndexToolVerificationResult.PhaseResult perTaskVerificationPhaseResult = new IndexToolVerificationResult.PhaseResult();
        verificationPhaseResultList.add(perTaskVerificationPhaseResult);
        for (Map.Entry<byte[], Put> entry : this.indexKeyToDataPutMap.entrySet()) {
            keys.add(PVarbinary.INSTANCE.getKeyRange(entry.getKey()));
            perTaskDataKeyToDataPutMap.put(entry.getValue().getRow(), entry.getValue());
            if (keys.size() != this.rowCountPerTask) continue;
            this.addVerifyTask(tasks, keys, perTaskDataKeyToDataPutMap, perTaskVerificationPhaseResult);
            keys = new ArrayList(this.rowCountPerTask);
            perTaskDataKeyToDataPutMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
            dataPutMapList.add(perTaskDataKeyToDataPutMap);
            perTaskVerificationPhaseResult = new IndexToolVerificationResult.PhaseResult();
            verificationPhaseResultList.add(perTaskVerificationPhaseResult);
        }
        if (keys.size() > 0) {
            this.addVerifyTask(tasks, keys, perTaskDataKeyToDataPutMap, perTaskVerificationPhaseResult);
        }
        Pair<List<Boolean>, List<Future<Boolean>>> resultsAndFutures = null;
        try {
            LOGGER.debug("Waiting on index verify tasks to complete...");
            resultsAndFutures = this.pool.submitUninterruptible(tasks);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Should not fail on the results while using a WaitForCompletionTaskRunner", e);
        }
        catch (EarlyExitFailure e) {
            throw new RuntimeException("Stopped while waiting for batch, quitting!", e);
        }
        int index = 0;
        for (Boolean bl : (List)resultsAndFutures.getFirst()) {
            if (bl == null) {
                Throwable cause = ServerUtil.getExceptionFromFailedFuture((Future)((List)resultsAndFutures.getSecond()).get(index));
                throw new IOException(this.exceptionMessage, cause);
            }
            ++index;
        }
        for (IndexToolVerificationResult.PhaseResult phaseResult : verificationPhaseResultList) {
            verificationPhaseResult.add(phaseResult);
        }
    }

    private void verifyIndex() throws IOException {
        IndexToolVerificationResult nextVerificationResult = new IndexToolVerificationResult(this.scan);
        nextVerificationResult.setScannedDataRowCount(this.indexKeyToDataPutMap.size());
        IndexToolVerificationResult.PhaseResult verificationPhaseResult = new IndexToolVerificationResult.PhaseResult();
        this.parallelizeIndexVerify(verificationPhaseResult);
        nextVerificationResult.getBefore().add(verificationPhaseResult);
        this.indexKeyToDataPutMap.clear();
        this.verificationResult.add(nextVerificationResult);
    }

    private void setMutationAttributes(Mutation m, byte[] uuidValue) {
        m.setAttribute(this.useProto ? "IdxProtoMD" : "IdxMD", this.indexMetaData);
        m.setAttribute("IdxUUID", uuidValue);
        m.setAttribute("_IGNORE_NEWER_MUTATIONS", BaseScannerRegionObserver.REPLAY_INDEX_REBUILD_WRITES);
        m.setAttribute("_ClientVersion", this.clientVersionBytes);
        m.setDurability(Durability.SKIP_WAL);
    }

    private byte[] commitIfReady(byte[] uuidValue, UngroupedAggregateRegionObserver.MutationList mutationList) throws IOException {
        if (ServerUtil.readyToCommit(mutationList.size(), mutationList.byteSize(), this.maxBatchSize, this.maxBatchSizeBytes)) {
            this.ungroupedAggregateRegionObserver.checkForRegionClosing();
            this.ungroupedAggregateRegionObserver.commitBatchWithRetries(this.region, mutationList, this.blockingMemstoreSize);
            uuidValue = ServerCacheClient.generateId();
            mutationList.clear();
        }
        return uuidValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(List<Cell> results) throws IOException {
        Cell lastCell = null;
        int rowCount = 0;
        this.region.startRegionOperation();
        try {
            RegionScanner regionScanner = this.innerScanner;
            synchronized (regionScanner) {
                byte[] uuidValue = ServerCacheClient.generateId();
                do {
                    ArrayList<Cell> row = new ArrayList<Cell>();
                    this.hasMore = this.innerScanner.nextRaw(row);
                    if (row.isEmpty()) continue;
                    lastCell = (Cell)row.get(0);
                    if (ScanUtil.isDummy(row)) break;
                    Put put = null;
                    Delete del = null;
                    for (Cell cell : row) {
                        if (KeyValue.Type.codeToType((byte)cell.getTypeByte()) == KeyValue.Type.Put) {
                            if (!this.partialRebuild && this.familyMap != null && !this.isColumnIncluded(cell)) continue;
                            if (put == null) {
                                put = new Put(CellUtil.cloneRow((Cell)cell));
                            }
                            put.add(cell);
                            continue;
                        }
                        if (del == null) {
                            del = new Delete(CellUtil.cloneRow((Cell)cell));
                        }
                        del.addDeleteMarker(cell);
                    }
                    if (put == null && del == null) continue;
                    if (!this.verify) {
                        if (put != null) {
                            this.setMutationAttributes((Mutation)put, uuidValue);
                            this.mutations.add((Mutation)put);
                        }
                        if (del != null) {
                            this.setMutationAttributes((Mutation)del, uuidValue);
                            this.mutations.add((Mutation)del);
                        }
                        uuidValue = this.commitIfReady(uuidValue, this.mutations);
                    } else {
                        this.indexKeyToDataPutMap.put(IndexerRegionScanner.getIndexRowKey(this.indexMaintainer, put), put);
                    }
                    ++rowCount;
                } while (this.hasMore && (long)rowCount < this.pageSizeInRows);
                if (this.verify) {
                    this.verifyIndex();
                } else if (!this.mutations.isEmpty()) {
                    this.ungroupedAggregateRegionObserver.checkForRegionClosing();
                    this.ungroupedAggregateRegionObserver.commitBatchWithRetries(this.region, this.mutations, this.blockingMemstoreSize);
                    this.mutations.clear();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("IOException during rebuilding: %s", Throwables.getStackTraceAsString((Throwable)e)));
            throw e;
        }
        finally {
            this.region.closeRegionOperation();
            if (this.verify) {
                this.indexKeyToDataPutMap.clear();
            } else {
                this.mutations.clear();
            }
        }
        byte[] rowCountBytes = PLong.INSTANCE.toBytes(rowCount);
        KeyValue aggKeyValue = lastCell == null ? KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length) : KeyValueUtil.newKeyValue(CellUtil.cloneRow((Cell)lastCell), QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length);
        results.add((Cell)aggKeyValue);
        return this.hasMore;
    }

    @Override
    public long getMaxResultSize() {
        return this.scan.getMaxResultSize();
    }
}

