/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor.tasks;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.coprocessor.tasks.BaseTask;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropChildViewsTask
extends BaseTask {
    public static final Logger LOGGER = LoggerFactory.getLogger(DropChildViewsTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskRegionObserver.TaskResult run(Task.TaskRecord taskRecord) {
        PhoenixConnection pconn = null;
        Timestamp timestamp = taskRecord.getTimeStamp();
        try {
            String tenantId = taskRecord.getTenantId();
            if (tenantId != null) {
                Properties tenantProps = new Properties();
                tenantProps.setProperty("TenantId", tenantId);
                pconn = QueryUtil.getConnectionOnServer(tenantProps, this.env.getConfiguration()).unwrap(PhoenixConnection.class);
            } else {
                pconn = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
            }
            MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(pconn).updateCache(pconn.getTenantId(), taskRecord.getSchemaName(), taskRecord.getTableName(), true);
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                ViewUtil.dropChildViews(this.env, taskRecord.getTenantIdBytes(), taskRecord.getSchemaNameBytes(), taskRecord.getTableNameBytes(), SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, this.env.getConfiguration()).getName());
                TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.SUCCESS, "");
                return taskResult;
            }
            if (EnvironmentEdgeManager.currentTimeMillis() < this.timeMaxInterval + timestamp.getTime()) {
                LOGGER.info("Skipping a child view drop task. The parent table has not been dropped yet : " + taskRecord.getSchemaName() + "." + taskRecord.getTableName() + " with tenant id " + (tenantId == null ? " IS NULL" : tenantId) + " and timestamp " + timestamp.toString());
                TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.SKIPPED, "");
                return taskResult;
            }
            LOGGER.warn(" A drop child view task has expired and will be marked as failed : " + taskRecord.getSchemaName() + "." + taskRecord.getTableName() + " with tenant id " + (tenantId == null ? " IS NULL" : tenantId) + " and timestamp " + timestamp.toString());
            TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, "Expired");
            return taskResult;
        }
        catch (Throwable t) {
            LOGGER.error("Exception while dropping a child view task. " + taskRecord.getSchemaName() + "." + taskRecord.getTableName() + " with tenant id " + (taskRecord.getTenantId() == null ? " IS NULL" : taskRecord.getTenantId()) + " and timestamp " + timestamp.toString(), t);
            TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, t.toString());
            return taskResult;
        }
        finally {
            if (pconn != null) {
                try {
                    pconn.close();
                }
                catch (SQLException ignored) {
                    LOGGER.debug("DropChildViewsTask can't close connection", (Throwable)ignored);
                }
            }
        }
    }

    @Override
    public TaskRegionObserver.TaskResult checkCurrentResult(Task.TaskRecord taskRecord) throws Exception {
        return null;
    }
}

