/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.optimize;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.ArrayAllComparisonNode;
import org.apache.phoenix.parse.ArrayAnyComparisonNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.ExistsParseNode;
import org.apache.phoenix.parse.InParseNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.schema.types.PDataType;

public class GenSubqueryParamValuesRewriter
extends ParseNodeRewriter {
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    private final ExpressionCompiler expressionCompiler;

    public static ParseNode replaceWithDummyValues(ParseNode where, StatementContext context) throws SQLException {
        return GenSubqueryParamValuesRewriter.rewrite(where, (ParseNodeRewriter)new GenSubqueryParamValuesRewriter(context));
    }

    private GenSubqueryParamValuesRewriter(StatementContext context) {
        this.expressionCompiler = new ExpressionCompiler(context);
    }

    protected List<ParseNode> generateDummyValues(ParseNode lhs, boolean multipleValues) throws SQLException {
        Expression expr = lhs.accept(this.expressionCompiler);
        PDataType type = expr.getDataType();
        if (!multipleValues) {
            return Arrays.asList(NODE_FACTORY.literal(type.getSampleValue(), type));
        }
        return Arrays.asList(NODE_FACTORY.literal(type.getSampleValue(), type), NODE_FACTORY.literal(type.getSampleValue(), type), NODE_FACTORY.literal(type.getSampleValue(), type));
    }

    @Override
    public ParseNode visitLeave(AndParseNode node, List<ParseNode> l) throws SQLException {
        return this.leaveCompoundNode(node, l, new ParseNodeRewriter.CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                if (children.isEmpty()) {
                    return null;
                }
                if (children.size() == 1) {
                    return children.get(0);
                }
                return NODE_FACTORY.and(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(OrParseNode node, List<ParseNode> l) throws SQLException {
        return this.leaveCompoundNode(node, l, new ParseNodeRewriter.CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                if (children.isEmpty()) {
                    return null;
                }
                if (children.size() == 1) {
                    return children.get(0);
                }
                return NODE_FACTORY.or(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(InParseNode node, List<ParseNode> l) throws SQLException {
        ParseNode lhs = l.get(0);
        List<ParseNode> inList = this.generateDummyValues(lhs, true);
        ArrayList<ParseNode> children = new ArrayList<ParseNode>();
        children.add(lhs);
        children.addAll(inList);
        return NODE_FACTORY.inList(children, node.isNegate());
    }

    @Override
    public ParseNode visitLeave(ExistsParseNode node, List<ParseNode> l) throws SQLException {
        return null;
    }

    @Override
    public ParseNode visitLeave(ComparisonParseNode node, List<ParseNode> l) throws SQLException {
        if (!(l.get(1) instanceof SubqueryParseNode)) {
            super.visitLeave(node, (List)l);
        }
        ParseNode lhs = l.get(0);
        List<ParseNode> rhs = this.generateDummyValues(lhs, false);
        ArrayList<ParseNode> children = new ArrayList<ParseNode>();
        children.add(lhs);
        children.add(rhs.get(0));
        return super.visitLeave(node, (List)children);
    }

    @Override
    public ParseNode visitLeave(ArrayAnyComparisonNode node, List<ParseNode> l) throws SQLException {
        ComparisonParseNode compare = (ComparisonParseNode)l.get(1);
        ParseNode lhs = compare.getLHS();
        List<ParseNode> rhs = this.generateDummyValues(lhs, false);
        return NODE_FACTORY.comparison(compare.getFilterOp(), lhs, rhs.get(0));
    }

    @Override
    public ParseNode visitLeave(ArrayAllComparisonNode node, List<ParseNode> l) throws SQLException {
        ComparisonParseNode compare = (ComparisonParseNode)l.get(1);
        ParseNode lhs = compare.getLHS();
        List<ParseNode> rhs = this.generateDummyValues(lhs, false);
        return NODE_FACTORY.comparison(compare.getFilterOp(), lhs, rhs.get(0));
    }
}

