/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.persist;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.tephra.persist.TransactionEdit;
import org.apache.tephra.persist.TransactionLogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSTransactionLogReaderV1
implements TransactionLogReader {
    private static final Logger LOG = LoggerFactory.getLogger(HDFSTransactionLogReaderV1.class);
    private final SequenceFile.Reader reader;
    private final LongWritable key;
    private boolean closed;

    public HDFSTransactionLogReaderV1(SequenceFile.Reader reader) {
        this.reader = reader;
        this.key = new LongWritable();
    }

    @Override
    public TransactionEdit next() throws IOException {
        return this.next(new TransactionEdit());
    }

    @Override
    public TransactionEdit next(TransactionEdit reuse) throws IOException {
        if (this.closed) {
            return null;
        }
        try {
            co.cask.tephra.persist.TransactionEdit oldTxEdit = new co.cask.tephra.persist.TransactionEdit();
            boolean successful = this.reader.next((Writable)this.key, (Writable)oldTxEdit);
            return successful ? TransactionEdit.convertCaskTxEdit(oldTxEdit) : null;
        }
        catch (EOFException e) {
            LOG.warn("Hit an unexpected EOF while trying to read the Transaction Edit. Skipping the entry.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.reader.close();
        this.closed = true;
    }
}

