/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.discovery;

import com.google.common.base.Charsets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import org.apache.twill.discovery.Discoverable;

final class DiscoverableAdapter {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)Discoverable.class), new DiscoverableCodec()).create();
    private static final Type BYTE_ARRAY_TYPE = new TypeToken<byte[]>(){}.getType();

    static byte[] encode(Discoverable discoverable) {
        return GSON.toJson((Object)discoverable, (Type)((Object)Discoverable.class)).getBytes(Charsets.UTF_8);
    }

    static Discoverable decode(byte[] encoded) {
        if (encoded == null) {
            return null;
        }
        return GSON.fromJson(new String(encoded, Charsets.UTF_8), Discoverable.class);
    }

    private DiscoverableAdapter() {
    }

    private static final class DiscoverableCodec
    implements JsonSerializer<Discoverable>,
    JsonDeserializer<Discoverable> {
        private DiscoverableCodec() {
        }

        @Override
        public Discoverable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            String service = jsonObj.get("service").getAsString();
            String hostname = jsonObj.get("hostname").getAsString();
            int port = jsonObj.get("port").getAsInt();
            byte[] payload = (byte[])context.deserialize(jsonObj.get("payload"), BYTE_ARRAY_TYPE);
            InetSocketAddress address = new InetSocketAddress(hostname, port);
            return new Discoverable(service, address, payload);
        }

        @Override
        public JsonElement serialize(Discoverable src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("service", src.getName());
            jsonObj.addProperty("hostname", src.getSocketAddress().getHostName());
            jsonObj.addProperty("port", src.getSocketAddress().getPort());
            jsonObj.add("payload", context.serialize(src.getPayload()));
            return jsonObj;
        }
    }
}

