/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RuleBasedDataGenerator;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class SequentialVarcharDataGenerator
implements RuleBasedDataGenerator {
    private final Column columnRule;
    private final AtomicLong counter;

    public SequentialVarcharDataGenerator(Column columnRule) {
        Preconditions.checkArgument(columnRule.getDataSequence() == DataSequence.SEQUENTIAL);
        Preconditions.checkArgument(this.isVarcharType(columnRule.getType()));
        this.columnRule = columnRule;
        this.counter = new AtomicLong(0L);
    }

    @Override
    public DataValue getDataValue() {
        DataValue data = null;
        long inc = this.counter.getAndIncrement();
        String strInc = String.valueOf(inc);
        int paddedLength = this.columnRule.getLengthExcludingPrefix();
        String strInc1 = StringUtils.leftPad(strInc, paddedLength, "x");
        String strInc2 = StringUtils.right(strInc1, this.columnRule.getLengthExcludingPrefix());
        String varchar = this.columnRule.getPrefix() != null ? this.columnRule.getPrefix() + strInc2 : strInc2;
        varchar = StringUtils.left(varchar, this.columnRule.getLength());
        data = new DataValue(this.columnRule.getType(), varchar);
        return data;
    }

    boolean isVarcharType(DataTypeMapping mapping) {
        switch (mapping) {
            case VARCHAR: 
            case VARBINARY: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }
}

