/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.LoadProfile;
import org.apache.phoenix.pherf.configuration.OperationGroup;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.TenantGroup;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.BaseLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;
import org.apache.phoenix.pherf.workload.mt.operations.Operation;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;

public class WeightedRandomLoadEventGenerator
extends BaseLoadEventGenerator {
    private final WeightedRandomSampler sampler;

    public WeightedRandomLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, Properties properties) {
        super(phoenixUtil, model, scenario, properties);
        this.sampler = new WeightedRandomSampler(this.operationFactory.getOperations(), model, scenario);
    }

    public WeightedRandomLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, List<PherfWorkHandler> workHandlers, Properties properties) {
        super(phoenixUtil, model, scenario, workHandlers, properties);
        this.sampler = new WeightedRandomSampler(this.operationFactory.getOperations(), model, scenario);
    }

    @Override
    public TenantOperationInfo next() {
        return this.sampler.nextSample();
    }

    private static class WeightedRandomSampler {
        private static String AUTO_WEIGHTED_OPERATION_ID = "xxxxxx";
        private final Random RANDOM = new Random();
        private final LoadProfile loadProfile;
        private final String modelName;
        private final String scenarioName;
        private final String tableName;
        private final EnumeratedDistribution<String> distribution;
        private final Map<String, TenantGroup> tenantGroupMap = Maps.newHashMap();
        private final Map<String, Operation> operationMap = Maps.newHashMap();
        private final List<String> autoWeightedOperations = Lists.newArrayList();
        private final int numAutoWeightedOperations;

        public WeightedRandomSampler(List<Operation> operationList, DataModel model, Scenario scenario) {
            this.modelName = model.getName();
            this.scenarioName = scenario.getName();
            this.tableName = scenario.getTableName();
            this.loadProfile = scenario.getLoadProfile();
            for (TenantGroup tg : this.loadProfile.getTenantDistribution()) {
                this.tenantGroupMap.put(tg.getId(), tg);
            }
            Preconditions.checkArgument(!this.tenantGroupMap.isEmpty(), "Tenant group cannot be empty");
            for (Operation op : operationList) {
                for (OperationGroup loadOp : this.loadProfile.getOpDistribution()) {
                    if (op.getId().compareTo(loadOp.getId()) != 0) continue;
                    this.operationMap.put(op.getId(), op);
                }
            }
            Preconditions.checkArgument(!this.operationMap.isEmpty(), "Operation list and load profile operation do not match");
            this.distribution = this.initProbabilityDistribution(scenario.getLoadProfile());
            this.numAutoWeightedOperations = this.autoWeightedOperations.size();
        }

        public TenantOperationInfo nextSample() {
            String sampleIndex = this.distribution.sample();
            String[] parts = sampleIndex.split(":");
            String tenantGroupId = parts[0];
            String opId = parts[1];
            Operation op = this.operationMap.get(opId);
            if (op == null && opId.compareTo(AUTO_WEIGHTED_OPERATION_ID) == 0) {
                opId = this.autoWeightedOperations.get(this.RANDOM.nextInt(this.numAutoWeightedOperations));
                op = this.operationMap.get(opId);
            }
            int numTenants = this.tenantGroupMap.get(tenantGroupId).getNumTenants();
            String tenantIdPrefix = Strings.padStart(tenantGroupId, this.loadProfile.getGroupIdLength(), 'x');
            String formattedTenantId = String.format(this.loadProfile.getTenantIdFormat(), tenantIdPrefix.substring(0, this.loadProfile.getGroupIdLength()), this.RANDOM.nextInt(numTenants));
            String paddedTenantId = Strings.padStart(formattedTenantId, this.loadProfile.getTenantIdLength(), 'x');
            String tenantId = paddedTenantId.substring(0, this.loadProfile.getTenantIdLength());
            TenantOperationInfo sample = new TenantOperationInfo(this.modelName, this.scenarioName, this.tableName, tenantGroupId, opId, tenantId, op);
            return sample;
        }

        private EnumeratedDistribution initProbabilityDistribution(LoadProfile loadProfile) {
            double totalTenantGroupWeight = 0.0;
            double totalOperationWeight = 0.0;
            double remainingOperationWeight = 0.0;
            for (TenantGroup tg : loadProfile.getTenantDistribution()) {
                Preconditions.checkArgument((float)tg.getWeight() > 0.0f, "Tenant group weight cannot be less than zero");
                totalTenantGroupWeight += (double)tg.getWeight();
            }
            for (OperationGroup op : loadProfile.getOpDistribution()) {
                if ((float)op.getWeight() > 0.0f) {
                    totalOperationWeight += (double)op.getWeight();
                    continue;
                }
                this.autoWeightedOperations.add(op.getId());
            }
            if (!this.autoWeightedOperations.isEmpty()) {
                remainingOperationWeight = 100.0 - totalOperationWeight;
                totalOperationWeight = 100.0;
            }
            Preconditions.checkArgument(totalTenantGroupWeight == 100.0, "Total tenant group weight cannot be <> 100.0");
            Preconditions.checkArgument(totalOperationWeight == 100.0, "Total operation group weight cannot be <> 100.0");
            ArrayList pmf = Lists.newArrayList();
            double totalWeight = totalTenantGroupWeight * totalOperationWeight;
            for (TenantGroup tg : loadProfile.getTenantDistribution()) {
                for (OperationGroup op : loadProfile.getOpDistribution()) {
                    int opWeight = op.getWeight();
                    if (!((float)opWeight > 0.0f)) continue;
                    String sampleName = String.format("%s:%s", tg.getId(), op.getId());
                    double probability = (double)(tg.getWeight() * opWeight) / totalWeight;
                    pmf.add(new Pair<String, Double>(sampleName, probability));
                }
                if (this.autoWeightedOperations.isEmpty()) continue;
                String sampleName = String.format("%s:%s", tg.getId(), AUTO_WEIGHTED_OPERATION_ID);
                double probability = (double)tg.getWeight() * remainingOperationWeight / totalWeight;
                pmf.add(new Pair<String, Double>(sampleName, probability));
            }
            EnumeratedDistribution distribution = new EnumeratedDistribution(pmf);
            return distribution;
        }
    }
}

