/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.operations;

import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.operations.Operation;

public class OperationStats {
    private final TenantOperationInfo input;
    private String handlerId;
    private final int status;
    private final long rowCount;
    private final long durationInMs;
    private final long startTime;

    public OperationStats(TenantOperationInfo input, long startTime, int status, long rowCount, long durationInMs) {
        this.input = input;
        this.startTime = startTime;
        this.status = status;
        this.rowCount = rowCount;
        this.durationInMs = durationInMs;
    }

    public String getModelName() {
        return this.input.getModelName();
    }

    public String getScenarioName() {
        return this.input.getScenarioName();
    }

    public String getTenantId() {
        return this.input.getTenantId();
    }

    public Operation.OperationType getOpType() {
        return this.input.getOperation().getType();
    }

    public String getTableName() {
        return this.input.getTableName();
    }

    public String getTenantGroup() {
        return this.input.getTenantGroupId();
    }

    public String getOperationGroup() {
        return this.input.getOperationGroupId();
    }

    public int getStatus() {
        return this.status;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public String getHandlerId() {
        return this.handlerId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getDurationInMs() {
        return this.durationInMs;
    }

    public List<ResultValue> getCsvRepresentation() {
        ArrayList<ResultValue> rowValues = new ArrayList<ResultValue>();
        rowValues.add(new ResultValue<String>(this.getModelName()));
        rowValues.add(new ResultValue<String>(this.getScenarioName()));
        rowValues.add(new ResultValue<String>(this.getTableName()));
        rowValues.add(new ResultValue<String>(this.getTenantId()));
        rowValues.add(new ResultValue<String>(this.handlerId));
        rowValues.add(new ResultValue<String>(this.getTenantGroup()));
        rowValues.add(new ResultValue<String>(this.getOperationGroup()));
        rowValues.add(new ResultValue<String>(this.getOpType().name()));
        rowValues.add(new ResultValue<String>(String.valueOf(this.startTime)));
        rowValues.add(new ResultValue<String>(String.valueOf(this.status)));
        rowValues.add(new ResultValue<String>(String.valueOf(this.rowCount)));
        rowValues.add(new ResultValue<String>(String.valueOf(this.durationInMs)));
        return rowValues;
    }

    public void setHandlerId(String handlerId) {
        this.handlerId = handlerId;
    }
}

