/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.configuration;

import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;

public class Column {
    private String name;
    private String prefix;
    private DataSequence dataSequence;
    private int length = Integer.MIN_VALUE;
    private int precision;
    private long minValue = Long.MIN_VALUE;
    private long maxValue = Long.MIN_VALUE;
    private int nullChance;
    private boolean userDefined = false;
    private List<DataValue> dataValues;
    private DataTypeMapping type;
    private boolean useCurrentDate = false;

    public Column() {
        this.precision = Integer.MIN_VALUE;
        this.nullChance = Integer.MIN_VALUE;
    }

    public Column(Column column) {
        this();
        this.type = column.type;
        this.mutate(column);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public boolean equals(Object column) {
        if (!(column instanceof Column)) {
            return false;
        }
        Column col = (Column)column;
        return this.getType() == col.getType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataSequence getDataSequence() {
        return this.dataSequence;
    }

    public void setDataSequence(DataSequence dataSequence) {
        this.dataSequence = dataSequence;
    }

    public int getLength() {
        return this.length;
    }

    public int getLengthExcludingPrefix() {
        return this.getPrefix() == null ? this.length : this.length - this.getPrefix().length();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public DataTypeMapping getType() {
        return this.type;
    }

    public void setType(DataTypeMapping type) {
        this.type = type;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setUseCurrentDate(boolean useCurrentDate) {
        this.useCurrentDate = useCurrentDate;
    }

    public boolean getUseCurrentDate() {
        return this.useCurrentDate;
    }

    public void mutate(Column column) {
        if (column.getMinValue() != Long.MIN_VALUE) {
            this.setMinValue(column.getMinValue());
        }
        if (column.getMaxValue() != Long.MIN_VALUE) {
            this.setMaxValue(column.getMaxValue());
        }
        if (column.getLength() != Integer.MIN_VALUE) {
            this.setLength(column.getLength());
        }
        if (column.getName() != null) {
            this.setName(column.getName());
        }
        if (column.getPrefix() != null) {
            this.setPrefix(column.getPrefix());
        }
        if (column.getDataSequence() != null) {
            this.setDataSequence(column.getDataSequence());
        }
        if (column.getNullChance() != Integer.MIN_VALUE) {
            this.setNullChance(column.getNullChance());
        }
        if (column.getPrecision() != Integer.MIN_VALUE) {
            this.setPrecision(column.getPrecision());
        }
        if (column.isUserDefined()) {
            this.setUserDefined(column.isUserDefined());
        }
        if (column.dataValues != null) {
            this.setDataValues(column.getDataValues());
        }
        if (column.getUseCurrentDate()) {
            this.setUseCurrentDate(column.getUseCurrentDate());
        }
    }

    public int getNullChance() {
        return this.nullChance;
    }

    public void setNullChance(int nullChance) {
        this.nullChance = nullChance;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    public List<DataValue> getDataValues() {
        return this.dataValues;
    }

    @XmlElementWrapper(name="valuelist")
    @XmlElement(name="datavalue")
    public void setDataValues(List<DataValue> dataValues) {
        this.dataValues = dataValues;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

