/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import sqlline.OutputFormat;
import sqlline.Rows;
import sqlline.SqlLine;

public class AnsiConsoleOutputFormat
implements OutputFormat {
    private final SqlLine sqlLine;

    AnsiConsoleOutputFormat(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    @Override
    public int print(Rows rows) {
        int index = 0;
        int width = this.getCalculatedWidth();
        rows.normalizeWidths(this.sqlLine.getOpts().getMaxColumnWidth());
        while (rows.hasNext()) {
            Rows.Row row = (Rows.Row)rows.next();
            AttributedString cbuf = this.getOutputString(row, index == 0 ? AttributedStyle.INVERSE : AttributedStyle.DEFAULT);
            cbuf = cbuf.substring(0, Math.min(cbuf.length(), width));
            this.printRow(cbuf);
            ++index;
        }
        return index - 1;
    }

    private int getCalculatedWidth() {
        int maxWidth = this.sqlLine.getOpts().getMaxWidth();
        return Math.max(maxWidth == 0 && this.sqlLine.getLineReader() != null ? this.sqlLine.getLineReader().getTerminal().getWidth() : maxWidth, 0);
    }

    void printRow(AttributedString cbuff) {
        this.sqlLine.output(cbuff);
    }

    public AttributedString getOutputString(Rows.Row row, AttributedStyle style) {
        return this.getOutputString(row, " ", style);
    }

    private AttributedString getOutputString(Rows.Row row, String delim, AttributedStyle style) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        for (int i = 0; i < row.values.length; ++i) {
            if (builder.length() > 0) {
                builder.append(delim);
            }
            builder.append(SqlLine.rpad(row.values[i], row.sizes[i]), style);
        }
        return builder.toAttributedString();
    }
}

