/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import sqlline.AbstractOutputFormat;
import sqlline.Rows;
import sqlline.SqlLine;

class SeparatedValuesOutputFormat
extends AbstractOutputFormat {
    private static final char DEFAULT_QUOTE_CHARACTER = '\"';
    final String separator;
    final char quoteCharacter;

    SeparatedValuesOutputFormat(SqlLine sqlLine, String separator, char quoteCharacter) {
        super(sqlLine);
        this.separator = separator;
        this.quoteCharacter = quoteCharacter;
    }

    SeparatedValuesOutputFormat(SqlLine sqlLine, String separator) {
        this(sqlLine, separator, '\"');
    }

    @Override
    void printHeader(Rows.Row header) {
        this.printRow(header);
    }

    @Override
    void printFooter(Rows.Row header) {
    }

    @Override
    void printRow(Rows rows, Rows.Row header, Rows.Row row) {
        this.printRow(row);
    }

    private void printRow(Rows.Row row) {
        String[] vals = row.values;
        StringBuilder buf = new StringBuilder();
        for (String val : vals) {
            buf.append(buf.length() == 0 ? "" : "" + this.separator).append(this.quoteCharacter);
            if (val != null) {
                for (char c : val.toCharArray()) {
                    if (c == this.quoteCharacter) {
                        buf.append(c);
                    }
                    buf.append(c);
                }
            }
            buf.append(this.quoteCharacter);
        }
        this.sqlLine.output(buf.toString());
    }
}

