/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event;

import java.util.Map;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRetentionPolicy;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;

public class LogHandlerAppStartedEvent
extends LogHandlerEvent {
    private final ApplicationId applicationId;
    private final ContainerLogsRetentionPolicy retentionPolicy;
    private final String user;
    private final Credentials credentials;
    private final Map<ApplicationAccessType, String> appAcls;
    private final LogAggregationContext logAggregationContext;

    public LogHandlerAppStartedEvent(ApplicationId appId, String user, Credentials credentials, ContainerLogsRetentionPolicy retentionPolicy, Map<ApplicationAccessType, String> appAcls) {
        this(appId, user, credentials, retentionPolicy, appAcls, null);
    }

    public LogHandlerAppStartedEvent(ApplicationId appId, String user, Credentials credentials, ContainerLogsRetentionPolicy retentionPolicy, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext) {
        super(LogHandlerEventType.APPLICATION_STARTED);
        this.applicationId = appId;
        this.user = user;
        this.credentials = credentials;
        this.retentionPolicy = retentionPolicy;
        this.appAcls = appAcls;
        this.logAggregationContext = logAggregationContext;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public ContainerLogsRetentionPolicy getLogRetentionPolicy() {
        return this.retentionPolicy;
    }

    public String getUser() {
        return this.user;
    }

    public Map<ApplicationAccessType, String> getApplicationAcls() {
        return this.appAcls;
    }

    public LogAggregationContext getLogAggregationContext() {
        return this.logAggregationContext;
    }
}

