/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.loadGenerator.DataGenerator;
import org.apache.hadoop.fs.loadGenerator.LoadGenerator;
import org.apache.hadoop.fs.loadGenerator.StructureGenerator;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestLoadGenerator
extends Configured
implements Tool {
    private static final Configuration CONF = new HdfsConfiguration();
    private static final int DEFAULT_BLOCK_SIZE = 10;
    private static final File OUT_DIR = PathUtils.getTestDir(TestLoadGenerator.class);
    private static final File DIR_STRUCTURE_FILE = new File(OUT_DIR, "dirStructure");
    private static final File FILE_STRUCTURE_FILE = new File(OUT_DIR, "fileStructure");
    private static final String DIR_STRUCTURE_FIRST_LINE = "/dir0";
    private static final String DIR_STRUCTURE_SECOND_LINE = "/dir1";
    private static final String FILE_STRUCTURE_FIRST_LINE = "/dir0/_file_0 0.3754598635933768";
    private static final String FILE_STRUCTURE_SECOND_LINE = "/dir1/_file_1 1.4729310851145203";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStructureGenerator() throws Exception {
        StructureGenerator sg = new StructureGenerator();
        String[] args = new String[]{"-maxDepth", "2", "-minWidth", "1", "-maxWidth", "2", "-numOfFiles", "2", "-avgFileSize", "1", "-outDir", OUT_DIR.getAbsolutePath(), "-seed", "1"};
        boolean MAX_DEPTH = true;
        int MIN_WIDTH = 3;
        int MAX_WIDTH = 5;
        int NUM_OF_FILES = 7;
        int AVG_FILE_SIZE = 9;
        int SEED = 13;
        try {
            Assert.assertEquals((long)0L, (long)sg.run(args));
            BufferedReader in = new BufferedReader(new FileReader(DIR_STRUCTURE_FILE));
            Assert.assertEquals((Object)DIR_STRUCTURE_FIRST_LINE, (Object)in.readLine());
            Assert.assertEquals((Object)DIR_STRUCTURE_SECOND_LINE, (Object)in.readLine());
            Assert.assertEquals(null, (Object)in.readLine());
            in.close();
            in = new BufferedReader(new FileReader(FILE_STRUCTURE_FILE));
            Assert.assertEquals((Object)FILE_STRUCTURE_FIRST_LINE, (Object)in.readLine());
            Assert.assertEquals((Object)FILE_STRUCTURE_SECOND_LINE, (Object)in.readLine());
            Assert.assertEquals(null, (Object)in.readLine());
            in.close();
            String oldArg = args[1];
            args[1] = "0";
            Assert.assertEquals((long)-1L, (long)sg.run(args));
            args[1] = oldArg;
            oldArg = args[3];
            args[3] = "-1";
            Assert.assertEquals((long)-1L, (long)sg.run(args));
            args[3] = oldArg;
            oldArg = args[5];
            args[5] = "-1";
            Assert.assertEquals((long)-1L, (long)sg.run(args));
            args[5] = oldArg;
            oldArg = args[7];
            args[7] = "-1";
            Assert.assertEquals((long)-1L, (long)sg.run(args));
            args[7] = oldArg;
            oldArg = args[7];
            args[7] = "-1";
            Assert.assertEquals((long)-1L, (long)sg.run(args));
            args[7] = oldArg;
            oldArg = args[9];
            args[9] = "-1";
            Assert.assertEquals((long)-1L, (long)sg.run(args));
            args[9] = oldArg;
            oldArg = args[13];
            args[13] = "34.d4";
            Assert.assertEquals((long)-1L, (long)sg.run(args));
            args[13] = oldArg;
        }
        finally {
            DIR_STRUCTURE_FILE.delete();
            FILE_STRUCTURE_FILE.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadGenerator() throws Exception {
        String TEST_SPACE_ROOT = "/test";
        String SCRIPT_TEST_DIR = OUT_DIR.getAbsolutePath();
        String script = SCRIPT_TEST_DIR + "/" + "loadgenscript";
        String script2 = SCRIPT_TEST_DIR + "/" + "loadgenscript2";
        File scriptFile1 = new File(script);
        File scriptFile2 = new File(script2);
        FileWriter writer = new FileWriter(DIR_STRUCTURE_FILE);
        writer.write("/dir0\n");
        writer.write("/dir1\n");
        writer.close();
        writer = new FileWriter(FILE_STRUCTURE_FILE);
        writer.write("/dir0/_file_0 0.3754598635933768\n");
        writer.write("/dir1/_file_1 1.4729310851145203\n");
        writer.close();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(3).build();
        cluster.waitActive();
        try {
            DataGenerator dg = new DataGenerator();
            dg.setConf(CONF);
            String[] args = new String[]{"-inDir", OUT_DIR.getAbsolutePath(), "-root", "/test"};
            Assert.assertEquals((long)0L, (long)dg.run(args));
            boolean READ_PROBABILITY = true;
            int WRITE_PROBABILITY = 3;
            int MAX_DELAY_BETWEEN_OPS = 7;
            int NUM_OF_THREADS = 9;
            int START_TIME = 11;
            int ELAPSED_TIME = 13;
            LoadGenerator lg = new LoadGenerator();
            lg.setConf(CONF);
            args = new String[]{"-readProbability", "0.3", "-writeProbability", "0.3", "-root", "/test", "-maxDelayBetweenOps", "0", "-numOfThreads", "1", "-startTime", Long.toString(Time.now()), "-elapsedTime", "10"};
            Assert.assertEquals((long)0L, (long)lg.run(args));
            String oldArg = args[1];
            args[1] = "1.1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[1] = "-1.1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[1] = oldArg;
            oldArg = args[3];
            args[3] = "1.1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[3] = "-1.1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[3] = "0.9";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[1] = oldArg;
            oldArg = args[7];
            args[7] = "1.x1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[7] = oldArg;
            oldArg = args[7];
            args[7] = "1.x1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[7] = oldArg;
            oldArg = args[9];
            args[9] = "-1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[9] = oldArg;
            oldArg = args[11];
            args[11] = "-1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[11] = oldArg;
            oldArg = args[13];
            args[13] = "-1";
            Assert.assertEquals((long)-1L, (long)lg.run(args));
            args[13] = oldArg;
            FileWriter fw = new FileWriter(scriptFile1);
            fw.write("2 .22 .33\n");
            fw.write("3 .10 .6\n");
            fw.write("6 0 .7\n");
            fw.close();
            String[] scriptArgs = new String[]{"-root", "/test", "-maxDelayBetweenOps", "0", "-numOfThreads", "10", "-startTime", Long.toString(Time.now()), "-scriptFile", script};
            Assert.assertEquals((long)0L, (long)lg.run(scriptArgs));
            fw = new FileWriter(scriptFile2);
            fw.write("2 .22 .33\n");
            fw.write("3 blah blah blah .6\n");
            fw.write("6 0 .7\n");
            fw.close();
            scriptArgs[scriptArgs.length - 1] = script2;
            Assert.assertEquals((long)-1L, (long)lg.run(scriptArgs));
        }
        finally {
            cluster.shutdown();
            DIR_STRUCTURE_FILE.delete();
            FILE_STRUCTURE_FILE.delete();
            scriptFile1.delete();
            scriptFile2.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new TestLoadGenerator(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        TestLoadGenerator loadGeneratorTest = new TestLoadGenerator();
        loadGeneratorTest.testStructureGenerator();
        loadGeneratorTest.testLoadGenerator();
        return 0;
    }

    static {
        CONF.setLong("dfs.blocksize", 10L);
        CONF.setInt("dfs.bytes-per-checksum", 10);
        CONF.setLong("dfs.heartbeat.interval", 1L);
    }
}

