/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;

public class TestRead {
    private final int BLOCK_SIZE = 512;

    private void testEOF(MiniDFSCluster cluster, int fileLength) throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("testEOF." + fileLength);
        DFSTestUtil.createFile((FileSystem)fs, path, fileLength, (short)1, -1091584273L);
        FSDataInputStream fis = fs.open(path);
        ByteBuffer empty = ByteBuffer.allocate(0);
        Assert.assertEquals((long)0L, (long)fis.read(empty));
        fis.seek((long)fileLength);
        Assert.assertEquals((long)-1L, (long)fis.read(empty));
        if (fileLength > 512) {
            fis.seek((long)(fileLength - 512 + 1));
            ByteBuffer dbb = ByteBuffer.allocateDirect(512);
            Assert.assertEquals((long)511L, (long)fis.read(dbb));
        }
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testEOFWithBlockReaderLocal() throws Exception {
        try (DFSTestUtil.ShortCircuitTestContext testContext = new DFSTestUtil.ShortCircuitTestContext("testEOFWithBlockReaderLocal");){
            Configuration conf = testContext.newConfiguration();
            conf.setLong("dfs.client.cache.readahead", 512L);
            MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
            this.testEOF(cluster, 1);
            this.testEOF(cluster, 14);
            this.testEOF(cluster, 10000);
            cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testEOFWithRemoteBlockReader() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.client.cache.readahead", 512L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        this.testEOF(cluster, 1);
        this.testEOF(cluster, 14);
        this.testEOF(cluster, 10000);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReadReservedPath() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.open(new Path("/.reserved/.inodes/file"));
            Assert.fail((String)"Open a non existing file should fail.");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            cluster.shutdown();
        }
    }
}

