/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.util.Daemon;
import org.junit.Assert;

public class BlockManagerTestUtil {
    public static void setNodeReplicationLimit(BlockManager blockManager, int limit) {
        blockManager.maxReplicationStreams = limit;
    }

    public static DatanodeDescriptor getDatanode(FSNamesystem ns, String storageID) {
        ns.readLock();
        try {
            DatanodeDescriptor datanodeDescriptor = ns.getBlockManager().getDatanodeManager().getDatanode(storageID);
            return datanodeDescriptor;
        }
        finally {
            ns.readUnlock();
        }
    }

    public static void updateState(BlockManager blockManager) {
        blockManager.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getReplicaInfo(FSNamesystem namesystem, Block b) {
        BlockManager bm = namesystem.getBlockManager();
        namesystem.readLock();
        try {
            int[] nArray = new int[]{BlockManagerTestUtil.getNumberOfRacks(bm, b), bm.countNodes(b).liveReplicas(), bm.neededReplications.contains(b) ? 1 : 0};
            return nArray;
        }
        finally {
            namesystem.readUnlock();
        }
    }

    private static int getNumberOfRacks(BlockManager blockManager, Block b) {
        HashSet<String> rackSet = new HashSet<String>(0);
        Collection corruptNodes = BlockManagerTestUtil.getCorruptReplicas(blockManager).getNodes(b);
        for (DatanodeStorageInfo storage : blockManager.blocksMap.getStorages(b)) {
            String rackName;
            DatanodeDescriptor cur = storage.getDatanodeDescriptor();
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur) || rackSet.contains(rackName = cur.getNetworkLocation())) continue;
            rackSet.add(rackName);
        }
        return rackSet.size();
    }

    public static Daemon getReplicationThread(BlockManager blockManager) {
        return blockManager.replicationThread;
    }

    public static void stopReplicationThread(BlockManager blockManager) throws IOException {
        blockManager.enableRMTerminationForTesting();
        blockManager.replicationThread.interrupt();
        try {
            blockManager.replicationThread.join();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted while trying to stop ReplicationMonitor");
        }
    }

    public static CorruptReplicasMap getCorruptReplicas(BlockManager blockManager) {
        return blockManager.corruptReplicas;
    }

    public static int getComputedDatanodeWork(BlockManager blockManager) throws IOException {
        return blockManager.computeDatanodeWork();
    }

    public static int computeInvalidationWork(BlockManager bm) {
        return bm.computeInvalidateWork(Integer.MAX_VALUE);
    }

    public static int computeAllPendingWork(BlockManager bm) {
        int work = BlockManagerTestUtil.computeInvalidationWork(bm);
        return work += bm.computeReplicationWork(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noticeDeadDatanode(NameNode nn, String dnName) {
        FSNamesystem namesystem = nn.getNamesystem();
        namesystem.writeLock();
        try {
            DatanodeManager dnm = namesystem.getBlockManager().getDatanodeManager();
            HeartbeatManager hbm = dnm.getHeartbeatManager();
            HeartbeatManager dnds = hbm.getDatanodes();
            DatanodeDescriptor theDND = null;
            for (DatanodeDescriptor dnd : dnds) {
                if (!dnd.getXferAddr().equals(dnName)) continue;
                theDND = dnd;
            }
            Assert.assertNotNull((String)("Could not find DN with name: " + dnName), theDND);
            HeartbeatManager heartbeatManager = hbm;
            synchronized (heartbeatManager) {
                DFSTestUtil.setDatanodeDead((DatanodeInfo)theDND);
                hbm.heartbeatCheck();
            }
        }
        finally {
            namesystem.writeUnlock();
        }
    }

    public static void setWritingPrefersLocalNode(BlockManager bm, boolean prefer) {
        BlockPlacementPolicy bpp = bm.getBlockPlacementPolicy();
        Preconditions.checkState((boolean)(bpp instanceof BlockPlacementPolicyDefault), (String)"Must use default policy, got %s", (Object[])new Object[]{bpp.getClass()});
        ((BlockPlacementPolicyDefault)bpp).setPreferLocalNode(prefer);
    }

    public static void checkHeartbeat(BlockManager bm) {
        bm.getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }

    public static int checkHeartbeatAndGetUnderReplicatedBlocksCount(FSNamesystem namesystem, BlockManager bm) {
        namesystem.writeLock();
        try {
            bm.getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            int n = bm.getUnderReplicatedNotMissingBlocks();
            return n;
        }
        finally {
            namesystem.writeUnlock();
        }
    }

    public static DatanodeStorageInfo updateStorage(DatanodeDescriptor dn, DatanodeStorage s) {
        return dn.updateStorage(s);
    }

    public static void rescanPostponedMisreplicatedBlocks(BlockManager bm) {
        bm.rescanPostponedMisreplicatedBlocks();
    }

    public static DatanodeDescriptor getLocalDatanodeDescriptor(boolean initializeStorage) {
        DatanodeDescriptor dn = new DatanodeDescriptor(DFSTestUtil.getLocalDatanodeID());
        if (initializeStorage) {
            dn.updateStorage(new DatanodeStorage(DatanodeStorage.generateUuid()));
        }
        return dn;
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, boolean initializeStorage) {
        return BlockManagerTestUtil.getDatanodeDescriptor(ipAddr, rackLocation, initializeStorage ? new DatanodeStorage(DatanodeStorage.generateUuid()) : null);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, DatanodeStorage storage) {
        return BlockManagerTestUtil.getDatanodeDescriptor(ipAddr, rackLocation, storage, "host");
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, DatanodeStorage storage, String hostname) {
        DatanodeDescriptor dn = DFSTestUtil.getDatanodeDescriptor(ipAddr, 50010, rackLocation, hostname);
        if (storage != null) {
            dn.updateStorage(storage);
        }
        return dn;
    }

    public static DatanodeStorageInfo newDatanodeStorageInfo(DatanodeDescriptor dn, DatanodeStorage s) {
        return new DatanodeStorageInfo(dn, s);
    }

    public static StorageReport[] getStorageReportsForDatanode(DatanodeDescriptor dnd) {
        ArrayList<StorageReport> reports = new ArrayList<StorageReport>();
        for (DatanodeStorageInfo storage : dnd.getStorageInfos()) {
            DatanodeStorage dns = new DatanodeStorage(storage.getStorageID(), storage.getState(), storage.getStorageType());
            StorageReport report = new StorageReport(dns, false, storage.getCapacity(), storage.getDfsUsed(), storage.getRemaining(), storage.getBlockPoolUsed());
            reports.add(report);
        }
        return reports.toArray(StorageReport.EMPTY_ARRAY);
    }

    public static void recheckDecommissionState(DatanodeManager dm) throws ExecutionException, InterruptedException {
        dm.getDecomManager().runMonitor();
    }
}

