/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.mover;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.mover.Mover;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestMover {
    static Mover newMover(Configuration conf) throws IOException {
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((long)1L, (long)namenodes.size());
        HashMap nnMap = Maps.newHashMap();
        for (URI nn : namenodes) {
            nnMap.put(nn, null);
        }
        List nncs = NameNodeConnector.newNameNodeConnectors((Map)nnMap, (String)Mover.class.getSimpleName(), (Path)Mover.MOVER_ID_PATH, (Configuration)conf, (int)5);
        return new Mover((NameNodeConnector)nncs.get(0), conf, new AtomicInteger(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleSameBlock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testScheduleSameBlock/file";
            FSDataOutputStream out = dfs.create(new Path("/testScheduleSameBlock/file"));
            out.writeChars("testScheduleSameBlock");
            out.close();
            Mover mover = TestMover.newMover((Configuration)conf);
            mover.init();
            Mover.Processor processor = new Mover.Processor(mover);
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testScheduleSameBlock/file", 0L).get(0);
            List locations = Mover.MLocation.toLocations((LocatedBlock)lb);
            Mover.MLocation ml = (Mover.MLocation)locations.get(0);
            Dispatcher.DBlock db = mover.newDBlock(lb.getBlock().getLocalBlock(), locations);
            ArrayList<StorageType> storageTypes = new ArrayList<StorageType>(Arrays.asList(StorageType.DEFAULT, StorageType.DEFAULT));
            Assert.assertTrue((boolean)processor.scheduleMoveReplica(db, ml, storageTypes));
            Assert.assertFalse((boolean)processor.scheduleMoveReplica(db, ml, storageTypes));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleBlockWithinSameNode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
        try {
            StorageType[] storageTypes;
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testScheduleWithinSameNode/file";
            Path dir = new Path("/testScheduleWithinSameNode");
            dfs.mkdirs(dir);
            dfs.setStoragePolicy(dir, "HOT");
            FSDataOutputStream out = dfs.create(new Path("/testScheduleWithinSameNode/file"));
            out.writeChars("testScheduleWithinSameNode");
            out.close();
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testScheduleWithinSameNode/file", 0L).get(0);
            for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
                Assert.assertTrue((StorageType.DISK == storageType ? 1 : 0) != 0);
            }
            dfs.setStoragePolicy(dir, "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", dir.toString()});
            Assert.assertEquals((String)"Movement to ARCHIVE should be successfull", (long)0L, (long)rc);
            Thread.sleep(3000L);
            lb = dfs.getClient().getLocatedBlocks("/testScheduleWithinSameNode/file", 0L).get(0);
            for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
                Assert.assertTrue((StorageType.ARCHIVE == storageType ? 1 : 0) != 0);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private void checkMovePaths(List<Path> actual, Path ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (Path p : expected) {
            Assert.assertTrue((boolean)actual.contains(p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCli() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).numDataNodes(0).build();
        try {
            Configuration conf = cluster.getConfiguration(0);
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "bar"});
                Assert.fail((String)"Expected exception for illegal path bar");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"bar is not absolute", (Throwable)e);
            }
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[0]);
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)namenodes.size());
            Assert.assertEquals((long)1L, (long)movePaths.size());
            URI nn = (URI)namenodes.iterator().next();
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            Assert.assertNull(movePaths.get(nn));
            movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "/bar"});
            namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)movePaths.size());
            nn = (URI)namenodes.iterator().next();
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            this.checkMovePaths((List)movePaths.get(nn), new Path("/foo"), new Path("/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithHAConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        HATestUtil.setFailoverConfigurations(cluster, (Configuration)conf, "MyCluster");
        try {
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "/bar"});
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)namenodes.size());
            Assert.assertEquals((long)1L, (long)movePaths.size());
            URI nn = (URI)namenodes.iterator().next();
            Assert.assertEquals((Object)new URI("hdfs://MyCluster"), (Object)nn);
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            this.checkMovePaths((List)movePaths.get(nn), new Path("/foo"), new Path("/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithFederation() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).numDataNodes(0).build();
        HdfsConfiguration conf = new HdfsConfiguration();
        DFSTestUtil.setFederatedConfiguration(cluster, (Configuration)conf);
        try {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)3L, (long)namenodes.size());
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo"});
                Assert.fail((String)"Expect exception for missing authority information");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"does not contain scheme and authority", (Throwable)e);
            }
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "hdfs:///foo"});
                Assert.fail((String)"Expect exception for missing authority information");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"does not contain scheme and authority", (Throwable)e);
            }
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "wrong-hdfs://ns1/foo"});
                Assert.fail((String)"Expect exception for wrong scheme");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"Cannot resolve the path", (Throwable)e);
            }
            Iterator iter = namenodes.iterator();
            URI nn1 = (URI)iter.next();
            URI nn2 = (URI)iter.next();
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", nn1 + "/foo", nn1 + "/bar", nn2 + "/foo/bar"});
            Assert.assertEquals((long)2L, (long)movePaths.size());
            this.checkMovePaths((List)movePaths.get(nn1), new Path("/foo"), new Path("/bar"));
            this.checkMovePaths((List)movePaths.get(nn2), new Path("/foo/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithFederationHA() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleHAFederatedTopology(3)).numDataNodes(0).build();
        HdfsConfiguration conf = new HdfsConfiguration();
        DFSTestUtil.setFederatedHAConfiguration(cluster, (Configuration)conf);
        try {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)3L, (long)namenodes.size());
            Iterator iter = namenodes.iterator();
            URI nn1 = (URI)iter.next();
            URI nn2 = (URI)iter.next();
            URI nn3 = (URI)iter.next();
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", nn1 + "/foo", nn1 + "/bar", nn2 + "/foo/bar", nn3 + "/foobar"});
            Assert.assertEquals((long)3L, (long)movePaths.size());
            this.checkMovePaths((List)movePaths.get(nn1), new Path("/foo"), new Path("/bar"));
            this.checkMovePaths((List)movePaths.get(nn2), new Path("/foo/bar"));
            this.checkMovePaths((List)movePaths.get(nn3), new Path("/foobar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTwoReplicaSameStorageTypeShouldNotSelect() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.ARCHIVE}}).build();
        try {
            StorageType[] storageTypes;
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testForTwoReplicaSameStorageTypeShouldNotSelect";
            FSDataOutputStream out = dfs.create(new Path("/testForTwoReplicaSameStorageTypeShouldNotSelect"), (short)2);
            out.writeChars("testForTwoReplicaSameStorageTypeShouldNotSelect");
            out.close();
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testForTwoReplicaSameStorageTypeShouldNotSelect", 0L).get(0);
            for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
                Assert.assertTrue((StorageType.DISK == storageType ? 1 : 0) != 0);
            }
            dfs.setStoragePolicy(new Path("/testForTwoReplicaSameStorageTypeShouldNotSelect"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testForTwoReplicaSameStorageTypeShouldNotSelect".toString()});
            Assert.assertEquals((String)"Movement to ARCHIVE should be successfull", (long)0L, (long)rc);
            Thread.sleep(3000L);
            lb = dfs.getClient().getLocatedBlocks("/testForTwoReplicaSameStorageTypeShouldNotSelect", 0L).get(0);
            storageTypes = lb.getStorageTypes();
            int archiveCount = 0;
            for (StorageType storageType : storageTypes) {
                if (StorageType.ARCHIVE != storageType) continue;
                ++archiveCount;
            }
            Assert.assertEquals((long)archiveCount, (long)2L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverFailedRetry() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.mover.retry.max.attempts", "2");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testMoverFailedRetry";
            FSDataOutputStream out = dfs.create(new Path("/testMoverFailedRetry"), (short)2);
            out.writeChars("testMoverFailedRetry");
            out.close();
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testMoverFailedRetry", 0L).get(0);
            cluster.corruptBlockOnDataNodesByDeletingBlockFile(lb.getBlock());
            dfs.setStoragePolicy(new Path("/testMoverFailedRetry"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testMoverFailedRetry".toString()});
            Assert.assertEquals((String)"Movement should fail after some retry", (long)ExitStatus.IO_EXCEPTION.getExitCode(), (long)rc);
        }
        finally {
            cluster.shutdown();
        }
    }
}

