/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.net.NetUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOfflineImageViewerForAcl {
    private static final Log LOG = LogFactory.getLog(TestOfflineImageViewerForAcl.class);
    private static File originalFsimage = null;
    static final HashMap<String, AclStatus> writtenAcls = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.namenode.acls.enabled", true);
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            Path dir = new Path("/dirWithNoAcl");
            hdfs.mkdirs(dir);
            writtenAcls.put(dir.toString(), hdfs.getAclStatus(dir));
            dir = new Path("/dirWithDefaultAcl");
            hdfs.mkdirs(dir);
            hdfs.setAcl(dir, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}));
            writtenAcls.put(dir.toString(), hdfs.getAclStatus(dir));
            Path file = new Path("/noAcl");
            FSDataOutputStream o = hdfs.create(file);
            o.write(23);
            o.close();
            writtenAcls.put(file.toString(), hdfs.getAclStatus(file));
            file = new Path("/withAcl");
            o = hdfs.create(file);
            o.write(23);
            o.close();
            hdfs.setAcl(file, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)}));
            writtenAcls.put(file.toString(), hdfs.getAclStatus(file));
            file = new Path("/withSeveralAcls");
            o = hdfs.create(file);
            o.write(23);
            o.close();
            hdfs.setAcl(file, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "group", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)}));
            writtenAcls.put(file.toString(), hdfs.getAclStatus(file));
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug((Object)("original FS image file is " + originalFsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() throws IOException {
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebImageViewerForAcl() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            AclStatus acl = webhdfs.getAclStatus(new Path("/dirWithNoAcl"));
            Assert.assertEquals((Object)writtenAcls.get("/dirWithNoAcl"), (Object)acl);
            acl = webhdfs.getAclStatus(new Path("/dirWithDefaultAcl"));
            Assert.assertEquals((Object)writtenAcls.get("/dirWithDefaultAcl"), (Object)acl);
            acl = webhdfs.getAclStatus(new Path("/noAcl"));
            Assert.assertEquals((Object)writtenAcls.get("/noAcl"), (Object)acl);
            acl = webhdfs.getAclStatus(new Path("/withAcl"));
            Assert.assertEquals((Object)writtenAcls.get("/withAcl"), (Object)acl);
            acl = webhdfs.getAclStatus(new Path("/withSeveralAcls"));
            Assert.assertEquals((Object)writtenAcls.get("/withSeveralAcls"), (Object)acl);
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/invalid/?op=GETACLSTATUS");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        }
    }
}

