/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWebHdfsWithMultipleNameNodes {
    static final Log LOG = WebHdfsTestUtil.LOG;
    private static final Configuration conf = new HdfsConfiguration();
    private static MiniDFSCluster cluster;
    private static WebHdfsFileSystem[] webhdfs;

    private static void setLogLevel() {
        ((Log4JLogger)LOG).getLogger().setLevel(Level.ALL);
        GenericTestUtils.setLogLevel((Log)NamenodeWebHdfsMethods.LOG, (Level)Level.ALL);
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
    }

    @BeforeClass
    public static void setupTest() {
        TestWebHdfsWithMultipleNameNodes.setLogLevel();
        try {
            TestWebHdfsWithMultipleNameNodes.setupCluster(4, 3);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setupCluster(int nNameNodes, int nDataNodes) throws Exception {
        LOG.info((Object)("nNameNodes=" + nNameNodes + ", nDataNodes=" + nDataNodes));
        conf.setBoolean("dfs.webhdfs.enabled", true);
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(nNameNodes)).numDataNodes(nDataNodes).build();
        cluster.waitActive();
        webhdfs = new WebHdfsFileSystem[nNameNodes];
        for (int i = 0; i < webhdfs.length; ++i) {
            InetSocketAddress addr = cluster.getNameNode(i).getHttpAddress();
            String uri = "webhdfs://" + addr.getHostName() + ":" + addr.getPort() + "/";
            TestWebHdfsWithMultipleNameNodes.webhdfs[i] = (WebHdfsFileSystem)FileSystem.get((URI)new URI(uri), (Configuration)conf);
        }
    }

    @AfterClass
    public static void shutdownCluster() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    private static String createString(String prefix, int i) {
        String suffix = "*********************".substring(0, i + 1);
        return prefix + i + suffix + "\n";
    }

    private static String[] createStrings(String prefix, String name) {
        String[] strings = new String[webhdfs.length];
        for (int i = 0; i < webhdfs.length; ++i) {
            strings[i] = TestWebHdfsWithMultipleNameNodes.createString(prefix, i);
            LOG.info((Object)(name + "[" + i + "] = " + strings[i]));
        }
        return strings;
    }

    @Test
    public void testRedirect() throws Exception {
        int i;
        String dir = "/testRedirect/";
        String filename = "file";
        Path p = new Path("/testRedirect/", "file");
        String[] writeStrings = TestWebHdfsWithMultipleNameNodes.createStrings("write to webhdfs ", "write");
        String[] appendStrings = TestWebHdfsWithMultipleNameNodes.createStrings("append to webhdfs ", "append");
        for (i = 0; i < webhdfs.length; ++i) {
            FSDataOutputStream out = webhdfs[i].create(p);
            out.write(writeStrings[i].getBytes());
            out.close();
        }
        for (i = 0; i < webhdfs.length; ++i) {
            long expected = writeStrings[i].length();
            Assert.assertEquals((long)expected, (long)webhdfs[i].getFileStatus(p).getLen());
        }
        for (i = 0; i < webhdfs.length; ++i) {
            int c;
            FSDataInputStream in = webhdfs[i].open(p);
            int j = 0;
            while ((c = in.read()) != -1) {
                Assert.assertEquals((long)writeStrings[i].charAt(j), (long)c);
                ++j;
            }
            in.close();
        }
        for (i = 0; i < webhdfs.length; ++i) {
            FSDataOutputStream out = webhdfs[i].append(p);
            out.write(appendStrings[i].getBytes());
            out.close();
        }
        for (i = 0; i < webhdfs.length; ++i) {
            long expected = writeStrings[i].length() + appendStrings[i].length();
            Assert.assertEquals((long)expected, (long)webhdfs[i].getFileStatus(p).getLen());
        }
        for (i = 0; i < webhdfs.length; ++i) {
            int c;
            StringBuilder b = new StringBuilder();
            FSDataInputStream in = webhdfs[i].open(p);
            while ((c = in.read()) != -1) {
                b.append((char)c);
            }
            int wlen = writeStrings[i].length();
            Assert.assertEquals((Object)writeStrings[i], (Object)b.substring(0, wlen));
            Assert.assertEquals((Object)appendStrings[i], (Object)b.substring(wlen));
            in.close();
        }
    }
}

