/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.event.LoggingAdapter;
import akka.remote.RemoteTransportException;
import akka.remote.security.provider.AkkaProvider$;
import akka.remote.transport.netty.SSLSettings;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.util.Try$;

public final class NettySSLSupport$ {
    public static final NettySSLSupport$ MODULE$;

    static {
        new NettySSLSupport$();
    }

    public SslHandler apply(SSLSettings settings, LoggingAdapter log, boolean isClient) {
        return isClient ? this.initializeClientSSL(settings, log) : this.initializeServerSSL(settings, log);
    }

    /*
     * WARNING - void declaration
     */
    public SecureRandom initializeCustomSecureRandom(Option<String> rngName, LoggingAdapter log) {
        Option<String> option;
        block6: {
            void var3_12;
            SecureRandom secureRandom;
            block3: {
                block5: {
                    Some some;
                    boolean bl;
                    block4: {
                        String s;
                        boolean bl2;
                        block2: {
                            bl = false;
                            some = null;
                            option = rngName;
                            if (!(option instanceof Some)) break block2;
                            bl = true;
                            some = (Some)option;
                            String r = (String)some.x();
                            boolean bl3 = "AES128CounterSecureRNG".equals(r) ? true : ("AES256CounterSecureRNG".equals(r) ? true : ("AES128CounterInetRNG".equals(r) ? true : "AES256CounterInetRNG".equals(r)));
                            if (!bl3) break block2;
                            log.debug("SSL random number generator set to: {}", (Object)r);
                            secureRandom = SecureRandom.getInstance(r, AkkaProvider$.MODULE$);
                            break block3;
                        }
                        if (!bl || !(bl2 = "SHA1PRNG".equals(s = (String)some.x()) ? true : "NativePRNG".equals(s))) break block4;
                        log.debug(new StringBuilder().append((Object)"SSL random number generator set to: ").append((Object)s).toString());
                        secureRandom = SecureRandom.getInstance(s);
                        break block3;
                    }
                    if (!bl) break block5;
                    String unknown = (String)some.x();
                    log.debug("Unknown SSLRandomNumberGenerator [{}] falling back to SecureRandom", (Object)unknown);
                    secureRandom = new SecureRandom();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                log.debug("SSLRandomNumberGenerator not specified, falling back to SecureRandom");
                secureRandom = new SecureRandom();
            }
            SecureRandom rng = secureRandom;
            rng.nextInt();
            return var3_12;
        }
        throw new MatchError(option);
    }

    public SslHandler initializeClientSSL(SSLSettings settings, LoggingAdapter log) {
        log.debug("Client SSL is enabled, initialising ...");
        Tuple3 tuple3 = new Tuple3(settings.SSLTrustStore(), settings.SSLTrustStorePassword(), settings.SSLProtocol());
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                String trustStore = (String)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String password = (String)some2.x();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        String protocol = (String)some3.x();
                        Option option4 = this.constructClientContext$1(settings, log, trustStore, password, protocol);
                        Option option5 = option4;
                        if (option5 instanceof Some) {
                            Some some4 = (Some)option5;
                            SSLContext context = (SSLContext)some4.x();
                            log.debug("Using client SSL context to create SSLEngine ...");
                            SSLEngine sslEngine = context.createSSLEngine();
                            sslEngine.setUseClientMode(true);
                            sslEngine.setEnabledCipherSuites((String[])settings.SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
                            SslHandler sslHandler = new SslHandler(sslEngine);
                            return sslHandler;
                        }
                        if (None$.MODULE$.equals(option5)) {
                            throw new GeneralSecurityException(new StringOps(Predef$.MODULE$.augmentString("Failed to initialize client SSL because SSL context could not be found.\" +\r\n              \"Make sure your settings are correct: [trust-store: %s] [trust-store-password: %s] [protocol: %s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{settings.SSLTrustStore(), settings.SSLTrustStorePassword(), settings.SSLProtocol()})));
                        }
                        throw new MatchError((Object)option5);
                    }
                }
            }
        }
        if (tuple3 != null) {
            Option trustStore = (Option)tuple3._1();
            Option password = (Option)tuple3._2();
            Option protocol = (Option)tuple3._3();
            throw new GeneralSecurityException(new StringOps(Predef$.MODULE$.augmentString("One or several SSL trust store settings are missing: [trust-store: %s] [trust-store-password: %s] [protocol: %s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trustStore, password, protocol})));
        }
        throw new MatchError((Object)tuple3);
    }

    public SslHandler initializeServerSSL(SSLSettings settings, LoggingAdapter log) {
        log.debug("Server SSL is enabled, initialising ...");
        Tuple4 tuple4 = new Tuple4(settings.SSLKeyStore(), settings.SSLKeyStorePassword(), settings.SSLKeyPassword(), settings.SSLProtocol());
        if (tuple4 != null) {
            Option option = (Option)tuple4._1();
            Option option2 = (Option)tuple4._2();
            Option option3 = (Option)tuple4._3();
            Option option4 = (Option)tuple4._4();
            if (option instanceof Some) {
                Some some = (Some)option;
                String keyStore = (String)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String storePassword = (String)some2.x();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        String keyPassword = (String)some3.x();
                        if (option4 instanceof Some) {
                            Some some4 = (Some)option4;
                            String protocol = (String)some4.x();
                            Option option5 = this.constructServerContext$1(settings, log, keyStore, storePassword, keyPassword, protocol);
                            Option option6 = option5;
                            if (option6 instanceof Some) {
                                Some some5 = (Some)option6;
                                SSLContext context = (SSLContext)some5.x();
                                log.debug("Using server SSL context to create SSLEngine ...");
                                SSLEngine sslEngine = context.createSSLEngine();
                                sslEngine.setUseClientMode(false);
                                sslEngine.setEnabledCipherSuites((String[])settings.SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
                                SslHandler sslHandler = new SslHandler(sslEngine);
                                return sslHandler;
                            }
                            if (None$.MODULE$.equals(option6)) {
                                throw new GeneralSecurityException(new StringOps(Predef$.MODULE$.augmentString("Failed to initialize server SSL because SSL context could not be found.\r\n           Make sure your settings are correct: [key-store: %s] [key-store-password: %s] [protocol: %s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{settings.SSLKeyStore(), settings.SSLKeyStorePassword(), settings.SSLProtocol()})));
                            }
                            throw new MatchError((Object)option6);
                        }
                    }
                }
            }
        }
        if (tuple4 != null) {
            Option keyStore = (Option)tuple4._1();
            Option storePassword = (Option)tuple4._2();
            Option keyPassword = (Option)tuple4._3();
            Option protocol = (Option)tuple4._4();
            throw new GeneralSecurityException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SSL key store settings went missing. [key-store: ", "] [key-store-password: ", "] [key-password: ", "] [protocol: ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyStore, storePassword, keyPassword, protocol})));
        }
        throw new MatchError((Object)tuple4);
    }

    /*
     * WARNING - void declaration
     */
    private final Option constructClientContext$1(SSLSettings settings, LoggingAdapter log, String trustStorePath, String trustStorePassword, String protocol) {
        try {
            SecureRandom rng = this.initializeCustomSecureRandom(settings.SSLRandomNumberGenerator(), log);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fin = new FileInputStream(trustStorePath);
            try {
                trustStore.load(fin, trustStorePassword.toCharArray());
            }
            catch (Throwable throwable) {
                void var13_9;
                Try$.MODULE$.apply((Function0)new Serializable((FileInputStream)var13_9){
                    public static final long serialVersionUID = 0L;
                    private final FileInputStream fin$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.fin$1.close();
                    }
                    {
                        this.fin$1 = fin$1;
                    }
                });
                throw throwable;
            }
            Try$.MODULE$.apply((Function0)new /* invalid duplicate definition of identical inner class */);
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            return Option$.MODULE$.apply((Object)SSLContext.getInstance(protocol)).map((Function1)new Serializable(rng, trustManagers){
                public static final long serialVersionUID = 0L;
                private final SecureRandom rng$1;
                private final TrustManager[] trustManagers$1;

                public final SSLContext apply(SSLContext ctx) {
                    ctx.init(null, this.trustManagers$1, this.rng$1);
                    return ctx;
                }
                {
                    this.rng$1 = rng$1;
                    this.trustManagers$1 = trustManagers$1;
                }
            });
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RemoteTransportException("Client SSL connection could not be established because SSL context could not be constructed", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new RemoteTransportException(new StringBuilder().append((Object)"Client SSL connection could not be established because: ").append((Object)iOException.getMessage()).toString(), iOException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RemoteTransportException("Client SSL connection could not be established because trust store could not be loaded", fileNotFoundException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Option constructServerContext$1(SSLSettings settings, LoggingAdapter log, String keyStorePath, String keyStorePassword, String keyPassword, String protocol) {
        try {
            SecureRandom rng = this.initializeCustomSecureRandom(settings.SSLRandomNumberGenerator(), log);
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fin = new FileInputStream(keyStorePath);
            try {
                keyStore.load(fin, keyStorePassword.toCharArray());
            }
            catch (Throwable throwable) {
                void var13_10;
                Try$.MODULE$.apply((Function0)new Serializable((FileInputStream)var13_10){
                    public static final long serialVersionUID = 0L;
                    private final FileInputStream fin$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.fin$2.close();
                    }
                    {
                        this.fin$2 = fin$2;
                    }
                });
                throw throwable;
            }
            Try$.MODULE$.apply((Function0)new /* invalid duplicate definition of identical inner class */);
            factory.init(keyStore, keyPassword.toCharArray());
            Option trustManagers = settings.SSLTrustStore().map((Function1)new Serializable(settings){
                public static final long serialVersionUID = 0L;
                private final SSLSettings settings$1;

                /*
                 * WARNING - void declaration
                 */
                public final TrustManager[] apply(String path) {
                    char[] pwd = (char[])this.settings$1.SSLTrustStorePassword().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final char[] apply(String x$2) {
                            return x$2.toCharArray();
                        }
                    }).orNull(Predef$.MODULE$.$conforms());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    FileInputStream fin = new FileInputStream(path);
                    try {
                        trustStore.load(fin, pwd);
                    }
                    catch (Throwable throwable) {
                        void var5_5;
                        Try$.MODULE$.apply((Function0)new Serializable(this, (FileInputStream)var5_5){
                            public static final long serialVersionUID = 0L;
                            private final FileInputStream fin$3;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.fin$3.close();
                            }
                            {
                                this.fin$3 = fin$3;
                            }
                        });
                        throw throwable;
                    }
                    Try$.MODULE$.apply((Function0)new /* invalid duplicate definition of identical inner class */);
                    trustManagerFactory.init(trustStore);
                    return trustManagerFactory.getTrustManagers();
                }
                {
                    this.settings$1 = settings$1;
                }
            });
            return Option$.MODULE$.apply((Object)SSLContext.getInstance(protocol)).map((Function1)new Serializable(rng, factory, trustManagers){
                public static final long serialVersionUID = 0L;
                private final SecureRandom rng$2;
                private final KeyManagerFactory factory$1;
                private final Option trustManagers$2;

                public final SSLContext apply(SSLContext ctx) {
                    ctx.init(this.factory$1.getKeyManagers(), (TrustManager[])this.trustManagers$2.orNull(Predef$.MODULE$.$conforms()), this.rng$2);
                    return ctx;
                }
                {
                    this.rng$2 = rng$2;
                    this.factory$1 = factory$1;
                    this.trustManagers$2 = trustManagers$2;
                }
            });
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new RemoteTransportException(new StringBuilder().append((Object)"Server SSL connection could not be established because: ").append((Object)iOException.getMessage()).toString(), iOException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", fileNotFoundException);
        }
    }

    private NettySSLSupport$() {
        MODULE$ = this;
        Security.addProvider(AkkaProvider$.MODULE$);
    }
}

