/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.MasterClientBase;
import tachyon.conf.TachyonConf;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.FileInfo;
import tachyon.thrift.FileSystemMasterService;
import tachyon.thrift.TachyonTException;

public final class WorkerFileSystemMasterClient
extends MasterClientBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private FileSystemMasterService.Client mClient = null;

    public WorkerFileSystemMasterClient(InetSocketAddress masterAddress, TachyonConf tachyonConf) {
        super(masterAddress, tachyonConf);
    }

    @Override
    protected String getServiceName() {
        return "FileSystemMaster";
    }

    @Override
    protected void afterConnect() {
        this.mClient = new FileSystemMasterService.Client(this.mProtocol);
    }

    public synchronized boolean persistFile(long fileId, long length) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.persistFile(fileId, length);
            }
            catch (TachyonTException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized FileInfo getFileInfo(long fileId) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getFileInfo(fileId);
            }
            catch (TachyonTException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized Set<Long> getPinList() throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.workerGetPinIdList();
            }
            catch (TachyonTException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }
}

